/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client;

import com.jme3.app.Application;
import com.jme3.app.BasicProfilerState;
import com.jme3.app.DebugKeysAppState;
import com.jme3.app.SimpleApplication;
import com.jme3.app.StatsAppState;
import com.jme3.app.state.AppState;
import com.jme3.app.state.ScreenshotAppState;
import com.jme3.app.state.StateTiming;
import com.jme3.input.RawInputListener;
import com.jme3.input.event.JoyAxisEvent;
import com.jme3.input.event.JoyButtonEvent;
import com.jme3.input.event.KeyInputEvent;
import com.jme3.input.event.MouseButtonEvent;
import com.jme3.input.event.MouseMotionEvent;
import com.jme3.input.event.TouchEvent;
import com.jme3.math.ColorRGBA;
import com.jme3.system.AppSettings;
import com.jme3.system.JmeContext;
import com.simsilica.lemur.GuiGlobals;
import com.simsilica.lemur.HAlignment;
import com.simsilica.lemur.Insets3f;
import com.simsilica.lemur.OptionPanelState;
import com.simsilica.lemur.component.QuadBackgroundComponent;
import com.simsilica.lemur.style.Attributes;
import com.simsilica.lemur.style.BaseStyles;
import com.simsilica.lemur.style.Styles;
import com.simsilica.sim.GameSystemManager;
import com.simsilica.state.BlackboardState;
import com.simsilica.state.CommandConsoleState;
import com.simsilica.state.DebugHudState;
import com.simsilica.state.MemoryDebugState;
import com.simsilica.state.MessageState;
import com.simsilica.thread.JobState;
import com.simsilica.util.LogAdapter;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.CountDownLatch;
import javax.imageio.ImageIO;
import javax.swing.UIManager;
import mythruna.SystemInfo;
import mythruna.client.ConfigurationState;
import mythruna.client.ErrorDialog;
import mythruna.client.GameSettingsState;
import mythruna.client.GuiState;
import mythruna.client.MainGameFunctions;
import mythruna.client.MainMenuState;
import mythruna.client.MythrunaConfig;
import mythruna.client.PerspectiveGuiState;
import mythruna.client.PostProcessingState;
import mythruna.client.ProgressState;
import mythruna.client.PrototypeModManagerState;
import mythruna.client.ScreenShotEffectState;
import mythruna.client.SplashWindow;
import mythruna.client.net.HostedGameState;
import mythruna.client.net.NetworkState;
import mythruna.client.opengl.DisplaySettings;
import mythruna.client.opengl.lwjgl2.Lwjgl2DisplayModeProvider;
import mythruna.client.sound.NullAudioRenderer;
import mythruna.client.sound.SoundState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class Main
extends SimpleApplication {
    static Logger log = LoggerFactory.getLogger(Main.class);
    private static final File SYSTEM_INFO = new File("system-info.txt");
    private static int regularPoolSize = 4;
    private static int priorityPoolSize = 4;
    private static int backgroundPoolSize = 2;
    private static Map<String, Object> configSettings = new TreeMap<String, Object>();
    private DisplaySettings displaySettings;
    private static final long NANOS_PER_MS = 1000000L;
    private static final long NANOS_PER_SECOND = 1000000000L;
    long lastTime = 0L;
    long expectedFrameTime = 16666666L;
    long expectedMultiplier = 4L;
    long frame = 0L;

    public static void main(String ... args) throws Exception {
        UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        LogAdapter.initialize();
        MythrunaConfig config = MythrunaConfig.getInstance();
        boolean useLegacyDialog = config.getStartupSetting("settings.legacy.dialog.enabled", false);
        if (useLegacyDialog) {
            Main.legacyMain(args);
            return;
        }
        SplashWindow splash = new SplashWindow(new Lwjgl2DisplayModeProvider());
        splash.popup(() -> Main.startGame(splash.getAppSettings(), splash.getDisplaySettings()));
    }

    protected static void setupConfig() {
        MythrunaConfig config = MythrunaConfig.getInstance();
        configSettings.putAll(config.getStartupSettings());
        int cores = Runtime.getRuntime().availableProcessors();
        double regularFactor = config.getStartupSettingDouble("PoolSize.RegularScale", 0.25);
        double priorityFactor = config.getStartupSettingDouble("PoolSize.RegularScale", 0.5);
        double backgroundFactor = config.getStartupSettingDouble("PoolSize.RegularScale", 0.25);
        regularPoolSize = (int)Math.max(1L, Math.round(regularFactor * (double)cores));
        priorityPoolSize = (int)Math.max(3L, Math.round(priorityFactor * (double)cores));
        backgroundPoolSize = (int)Math.max(1L, Math.round(backgroundFactor * (double)cores));
        configSettings.put("threadCount[regular]", regularPoolSize);
        configSettings.put("threadCount[priority]", priorityPoolSize);
        configSettings.put("threadCount[background]", backgroundPoolSize);
    }

    protected static void setupIcons(AppSettings settings) {
        try {
            Object[] icons = new BufferedImage[]{ImageIO.read(Main.class.getResource("/Interface/dragon-128.png")), ImageIO.read(Main.class.getResource("/Interface/dragon-16.png")), ImageIO.read(Main.class.getResource("/Interface/dragon-32.png")), ImageIO.read(Main.class.getResource("/Interface/dragon-64.png"))};
            settings.setIcons(icons);
        }
        catch (Exception e) {
            log.warn("Error loading window icons", (Throwable)e);
        }
    }

    protected static void legacyMain(String ... args) throws Exception {
        Main.setupConfig();
        AppSettings settings = new AppSettings(true);
        settings.setWidth(1280);
        settings.setHeight(720);
        settings.setVSync(true);
        settings.setGammaCorrection(false);
        settings.load("Mythruna");
        settings.setTitle("Mythruna");
        MythrunaConfig config = MythrunaConfig.getInstance();
        boolean enableJoysticks = config.getStartupSetting("joysticks.enabled", true);
        settings.setUseJoysticks(enableJoysticks);
        log.info("joysticks enabled:" + enableJoysticks);
        settings.setSettingsDialogImage("/Interface/mythruna-test-title.png");
        Main.setupIcons(settings);
        Boolean disableAudio = config.getStartupSetting("DisableAudio", Boolean.FALSE);
        if (disableAudio.booleanValue()) {
            settings.setAudioRenderer(null);
        }
        log.info("audio renderer:" + settings.getAudioRenderer());
        Main main = new Main(null);
        main.setSettings(settings);
        main.start();
    }

    protected static void startGame(AppSettings settings, DisplaySettings displaySettings) {
        log.info("startGame()");
        settings.setTitle("Mythruna");
        Main.setupIcons(settings);
        Main main = new Main(displaySettings);
        main.setSettings(settings);
        main.setShowSettings(false);
        main.start();
    }

    public Main(DisplaySettings displaySettings) {
        super(new AppState[]{new StatsAppState(), new DebugKeysAppState(), new BasicProfilerState(false), new ConfigurationState(), new BlackboardState("global"), new GuiState(), new PerspectiveGuiState(), new PostProcessingState(), new OptionPanelState(), new DebugHudState(), new MemoryDebugState(), new CommandConsoleState(), new MessageState(), new NetworkState(), new MainMenuState(), new GameSettingsState(), new SoundState(), new JobState("regularWorkers", regularPoolSize, 1), new JobState("priorityWorkers", priorityPoolSize, 1), new JobState("backgroundWorkers", backgroundPoolSize, 1), new ProgressState(), new com.simsilica.mworld.view.ProgressState(), new ScreenshotAppState("", System.currentTimeMillis()), new ScreenShotEffectState()});
        this.displaySettings = displaySettings;
    }

    public void initialize() {
        super.initialize();
        if (this.audioRenderer == null) {
            this.initNullAudio();
        }
    }

    protected void initNullAudio() {
        log.info("Need to initialize a null audio renderer...");
        this.audioRenderer = new NullAudioRenderer();
    }

    public void simpleInitApp() {
        if (this.displaySettings != null) {
            try {
                MythrunaConfig config = MythrunaConfig.getInstance();
                String json = MythrunaConfig.toJson(this.displaySettings);
                config.getStartupSettings().put("settings.displaySettings", json);
                config.save();
            }
            catch (Exception e) {
                log.error("Error updating settings", (Throwable)e);
            }
        }
        this.stateManager.setStateTiming(new StateTiming());
        if (this.inputManager.hasMapping("SIMPLEAPP_Exit")) {
            this.inputManager.deleteMapping("SIMPLEAPP_Exit");
        }
        SystemInfo.initialize((JmeContext)this.getContext(), configSettings).write(SYSTEM_INFO);
        this.setPauseOnLostFocus(false);
        this.setDisplayFps(false);
        this.setDisplayStatView(false);
        if (this.stateManager.getState(StatsAppState.class) != null) {
            this.inputManager.deleteMapping("SIMPLEAPP_HideStats");
        }
        GuiGlobals.initialize((Application)this);
        GuiGlobals globals = GuiGlobals.getInstance();
        MainGameFunctions.initializeDefaultMappings(globals.getInputMapper());
        globals.getInputMapper().addDelegate(MainGameFunctions.F_JME_STATS, (Object)this.stateManager.getState(StatsAppState.class), "toggleStats");
        globals.getInputMapper().addDelegate(MainGameFunctions.F_CURSOR_RESET, (Object)this, "forceToggleCursor");
        globals.getInputMapper().addDelegate(MainGameFunctions.F_ALT_SCREENSHOT, (Object)this.stateManager.getState(ScreenshotAppState.class), "takeScreenshot");
        globals.getInputMapper().addDelegate(MainGameFunctions.F_HAND_DRAWN, (Object)this.stateManager.getState(GameSettingsState.class), "toggleHandDrawn");
        globals.getInputMapper().addDelegate(MainGameFunctions.F_DEBUG_HUD, (Object)this.stateManager.getState(GameSettingsState.class), "toggleDebugHud");
        BaseStyles.loadStyleResources((String)"/Interface/mythruna-ui.groovy");
        globals.getStyles().setDefaultStyle("paper");
        Styles styles = globals.getStyles();
        Attributes attrs = styles.getSelector(DebugHudState.CONTAINER_ID, "paper");
        attrs.set("background", null);
        attrs = styles.getSelector(DebugHudState.NAME_ID, "paper");
        attrs.set("color", (Object)ColorRGBA.White);
        attrs.set("fontSize", (Object)12);
        attrs.set("background", (Object)new QuadBackgroundComponent(new ColorRGBA(0.0f, 0.0f, 0.0f, 0.5f)));
        attrs.set("textHAlignment", (Object)HAlignment.Right);
        attrs.set("insets", (Object)new Insets3f(0.0f, 0.0f, 0.0f, 0.0f));
        attrs = styles.getSelector(DebugHudState.VALUE_ID, "paper");
        attrs.set("color", (Object)ColorRGBA.White);
        attrs.set("fontSize", (Object)12);
        attrs.set("background", (Object)new QuadBackgroundComponent(new ColorRGBA(0.0f, 0.0f, 0.0f, 0.5f)));
        attrs.set("insets", (Object)new Insets3f(0.0f, 0.0f, 0.0f, 0.0f));
        if (MythrunaConfig.getInstance().getStartupSetting("prototypeMods.enabled", false).booleanValue()) {
            this.stateManager.attach((AppState)new PrototypeModManagerState());
        }
    }

    public void simpleUpdate(float tpf) {
        long delta;
        String frameText = String.format("v%05d", this.frame);
        ++this.frame;
        MDC.put((String)"frame", (String)frameText);
        long time = System.nanoTime();
        if (this.lastTime != 0L && (delta = time - this.lastTime) > this.expectedFrameTime * this.expectedMultiplier) {
            log.warn(String.format("Detected frame lag exceeding: %.03f ms, calculated: %.03f ms, JME tpf: %.03f s", (double)(this.expectedFrameTime * this.expectedMultiplier) / 1000000.0, (double)delta / 1000000.0, Float.valueOf(tpf)));
        }
        this.lastTime = time;
    }

    public void handleError(String errMsg, Throwable t) {
        log.error("Unexpected error:" + errMsg, t);
        CountDownLatch canExit = new CountDownLatch(1);
        HostedGameState gameState = (HostedGameState)this.stateManager.getState(HostedGameState.class, false);
        if (gameState != null) {
            GameSystemManager systems = gameState.getSystems();
            Thread monitor = new Thread(() -> {
                try {
                    while (systems.isInitialized()) {
                        log.info("GameSystemManager still initialized:" + systems.isInitialized());
                        Thread.sleep(100L);
                    }
                }
                catch (InterruptedException e) {
                    log.error("interrupted while waiting", (Throwable)e);
                }
                log.info("GameSystemManager finished shutting down.");
                canExit.countDown();
            });
            monitor.setName("GameSystemShutdownMonitor");
            monitor.setDaemon(true);
            monitor.start();
        } else {
            canExit.countDown();
        }
        ErrorDialog dialog = new ErrorDialog(errMsg, t, canExit);
        dialog.setVisible(true);
        this.stop();
    }

    public void forceToggleCursor() {
        boolean enabled = this.getInputManager().isCursorVisible();
        this.getInputManager().setCursorVisible(!enabled);
        GuiGlobals.getInstance().setCursorEventsEnabled(!enabled, true);
    }

    public class TestJoystickEventListener
    implements RawInputListener {
        public TestJoystickEventListener(Main this$0) {
        }

        public void beginInput() {
        }

        public void endInput() {
        }

        public void onJoyAxisEvent(JoyAxisEvent evt) {
            log.info("onJoyAxisEvent(" + evt + ")");
        }

        public void onJoyButtonEvent(JoyButtonEvent evt) {
            log.info("onJoyButtonEvent(button:" + evt.getButton() + ", buttonIndex:" + evt.getButtonIndex() + ", joyIndex:" + evt.getJoyIndex() + ", isPressed:" + evt.isPressed() + ")");
        }

        public void onKeyEvent(KeyInputEvent evt) {
        }

        public void onMouseButtonEvent(MouseButtonEvent evt) {
        }

        public void onMouseMotionEvent(MouseMotionEvent evt) {
        }

        public void onTouchEvent(TouchEvent evt) {
        }
    }
}

