/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client;

import com.jme3.app.Application;
import com.jme3.app.state.BaseAppState;
import com.jme3.light.AmbientLight;
import com.jme3.light.DirectionalLight;
import com.jme3.light.Light;
import com.jme3.material.Material;
import com.jme3.material.RenderState;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Quaternion;
import com.jme3.math.Ray;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.renderer.Camera;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.ViewPort;
import com.jme3.renderer.queue.GeometryComparator;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.shape.Quad;
import com.jme3.texture.Texture;
import com.simsilica.lemur.GuiGlobals;
import com.simsilica.lemur.LayerComparator;
import com.simsilica.lemur.ListBox;
import com.simsilica.lemur.core.VersionedReference;
import com.simsilica.lemur.event.BasePickState;
import mythruna.client.GuiState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PerspectiveGuiState
extends BaseAppState {
    static Logger log = LoggerFactory.getLogger(PerspectiveGuiState.class);
    private Node previousGuiNode;
    private Camera guiCam;
    private float fov = 45.0f;
    private float nearPlane = 1.0f;
    private float farPlane = 2000.0f;
    private ViewPort viewport;
    private ViewPort guiViewPort;
    private Node root = new Node("Perspective GUI root");
    private DirectionalLight light;
    private AmbientLight ambient;
    private VersionedReference<Float> standardScaleRef;
    private float neutralPlane;
    private boolean worldSpaceNeutral = true;
    private Node perspectiveRoot = new Node("Zero Plane");
    private Node glassRoot = new Node("Glass Plane");
    public LayerComparator debugComparator;

    public PerspectiveGuiState() {
    }

    public PerspectiveGuiState(String id) {
        super(id);
    }

    public Node getRoot() {
        return this.perspectiveRoot;
    }

    public Node getRawGlassRoot() {
        return this.glassRoot;
    }

    public Camera getGuiCamera() {
        return this.guiCam;
    }

    public Vector2f getGuiSize() {
        return ((GuiState)this.getState(GuiState.class)).getGuiSize();
    }

    public DirectionalLight getGuiSun() {
        return this.light;
    }

    public AmbientLight getGuiAmbient() {
        return this.ambient;
    }

    public Vector3f getGuiLocation(Vector3f world) {
        return this.perspectiveRoot.worldToLocal(world, null);
    }

    public Ray getPerspectiveRay(Vector2f pos) {
        Vector3f clickNear = this.guiCam.getWorldCoordinates(pos, 0.0f);
        Vector3f clickFar = this.guiCam.getWorldCoordinates(pos, 1.0f);
        Vector3f clickDir = clickFar.subtractLocal(clickNear).normalizeLocal();
        if (clickDir.isUnitVector()) {
            return new Ray(clickNear, clickDir);
        }
        return null;
    }

    public Spatial createVignette() {
        Texture blur = this.getApplication().getAssetManager().loadTexture("Interface/radial-blur128.png");
        int backgroundWidth = 3000;
        int backgroundHeight = 2000;
        Quad big = new Quad((float)backgroundWidth, (float)backgroundHeight);
        Geometry geom = new Geometry("background", (Mesh)big);
        Material mat = GuiGlobals.getInstance().createMaterial(blur, false).getMaterial();
        mat.setColor("Color", new ColorRGBA(0.0f, 0.0f, 0.0f, 1.5f));
        mat.getAdditionalRenderState().setBlendMode(RenderState.BlendMode.Alpha);
        geom.setMaterial(mat);
        geom.setQueueBucket(RenderQueue.Bucket.Transparent);
        Vector2f offset = this.getGuiSize().mult(0.5f);
        geom.setLocalTranslation(offset.x - (float)(backgroundWidth / 2), offset.y - (float)(backgroundHeight / 2), -500.0f);
        return geom;
    }

    protected void resetProjection() {
        float z;
        float aspect = (float)this.guiCam.getWidth() / (float)this.guiCam.getHeight();
        this.guiCam.setFrustumPerspective(this.fov, aspect, this.nearPlane, this.farPlane);
        if (!this.worldSpaceNeutral) {
            this.guiCam.setRotation(new Quaternion().fromAngles(0.0f, (float)Math.PI, 0.0f));
        }
        float m11 = this.guiCam.getViewProjectionMatrix().m11;
        float standardScale = ((Float)this.standardScaleRef.get()).floatValue();
        this.neutralPlane = z = m11 * ((float)this.guiCam.getHeight() / standardScale) * 0.5f;
        log.info("Setting z to:" + z);
        if (!this.worldSpaceNeutral) {
            this.guiCam.setLocation(new Vector3f(0.0f, 0.0f, z));
        }
        float xOffset = (float)this.guiCam.getWidth() * 0.5f;
        float yOffset = (float)this.guiCam.getHeight() * 0.5f;
        if (this.worldSpaceNeutral) {
            this.guiCam.setRotation(Quaternion.IDENTITY.clone());
            this.root.rotate(0.0f, (float)Math.PI, 0.0f);
            this.root.setLocalTranslation(xOffset, -yOffset, z);
        } else {
            this.root.setLocalTranslation(-xOffset, -yOffset, 0.0f);
        }
    }

    protected void initialize(Application app) {
        this.root.setCullHint(Spatial.CullHint.Never);
        this.standardScaleRef = ((GuiState)this.getState(GuiState.class, true)).createStandardScaleReference();
        float standardScale = ((Float)this.standardScaleRef.get()).floatValue();
        log.info("Setting standard scale to:" + standardScale);
        Camera appCam = app.getCamera();
        this.guiCam = new Camera(appCam.getWidth(), appCam.getHeight());
        this.resetProjection();
        this.viewport = app.getRenderManager().createPostView("Perspective GUI ViewPort", this.guiCam);
        this.viewport.setEnabled(this.isEnabled());
        this.viewport.setClearFlags(false, true, true);
        this.viewport.attachScene((Spatial)this.root);
        Camera guiCam = new Camera(appCam.getWidth(), appCam.getHeight());
        this.guiViewPort = app.getRenderManager().createPostView("Glass Plane", guiCam);
        this.guiViewPort.setClearFlags(false, false, false);
        this.guiViewPort.attachScene((Spatial)this.glassRoot);
        this.glassRoot.setQueueBucket(RenderQueue.Bucket.Gui);
        this.glassRoot.setCullHint(Spatial.CullHint.Never);
        GuiGlobals.getInstance().setupGuiComparators(this.viewport);
        ((BasePickState)this.getState(BasePickState.class)).addCollisionRoot(this.guiViewPort, "gui");
        ((BasePickState)this.getState(BasePickState.class)).addCollisionRoot(this.viewport, "scene");
        RenderQueue rq = this.viewport.getQueue();
        this.debugComparator = new LayerComparator((GeometryComparator)new CenterComparator(this), -1);
        rq.setGeometryComparator(RenderQueue.Bucket.Transparent, (GeometryComparator)this.debugComparator);
        this.light = new DirectionalLight(this){

            public void setColor(ColorRGBA color) {
                this.color = color;
            }
        };
        if (this.worldSpaceNeutral) {
            this.light.setDirection(new Vector3f(-1.0f, -0.5f, 1.5f).normalizeLocal());
        } else {
            this.light.setDirection(new Vector3f(1.0f, -0.5f, 1.5f).normalizeLocal());
        }
        this.root.addLight((Light)this.light);
        this.ambient = new AmbientLight();
        this.ambient.setColor(ColorRGBA.Gray);
        this.root.addLight((Light)this.ambient);
        float width = guiCam.getWidth();
        float height = guiCam.getHeight();
        float nearDist = 5.0f;
        float nearScale = nearDist / this.neutralPlane;
        log.info("nearScale:" + nearScale + "  nearDist:" + nearDist + "  neutralPlane:" + this.neutralPlane);
        this.perspectiveRoot.setLocalScale(nearScale);
        this.perspectiveRoot.setLocalTranslation(width / 2.0f, height / 2.0f, this.neutralPlane - nearDist);
        this.perspectiveRoot.move(-nearScale * width / 2.0f / standardScale, -nearScale * height / 2.0f / standardScale, 0.0f);
        this.root.attachChild((Spatial)this.perspectiveRoot);
        this.root.updateLogicalState(1.0f);
        this.root.updateGeometricState();
        this.glassRoot.updateLogicalState(1.0f);
        this.glassRoot.updateGeometricState();
    }

    protected void testIt(ListBox<String> guiList, ListBox<String> perspList) {
        this.dump("", (Spatial)guiList, guiList.getWorldTranslation().z);
        this.dump("", (Spatial)perspList, perspList.getWorldTranslation().z);
    }

    protected void dump(String indent, Spatial s, float yBase) {
        Object layer = "";
        if (s instanceof Geometry) {
            layer = "  layer:" + this.debugComparator.getLayer((Geometry)s);
        }
        log.info(indent + s + " z:" + s.getWorldTranslation().z + (String)layer);
        if (s instanceof Node) {
            for (Spatial child : ((Node)s).getChildren()) {
                this.dump(indent + "  ", child, yBase);
            }
        }
    }

    protected void cleanup(Application app) {
    }

    protected void onEnable() {
        this.viewport.setEnabled(true);
        this.guiViewPort.setEnabled(true);
        this.previousGuiNode = GuiGlobals.getInstance().getPopupState().getGuiNode();
    }

    protected void onDisable() {
        this.viewport.setEnabled(false);
        this.guiViewPort.setEnabled(false);
        this.root.updateGeometricState();
        this.glassRoot.updateGeometricState();
    }

    public void update(float tpf) {
        this.root.updateLogicalState(tpf);
        this.glassRoot.updateLogicalState(tpf);
    }

    public void render(RenderManager rm) {
        this.root.updateGeometricState();
        this.glassRoot.updateGeometricState();
    }

    private /* synthetic */ void lambda$initialize$0(ListBox testListBox, ListBox third) {
        this.testIt((ListBox<String>)testListBox, (ListBox<String>)third);
    }

    private class CenterComparator
    implements GeometryComparator {
        private Camera cam;

        public CenterComparator(PerspectiveGuiState perspectiveGuiState) {
        }

        public void setCamera(Camera cam) {
            this.cam = cam;
        }

        private float distanceToCam(Geometry spat) {
            return spat.getWorldTranslation().dot(this.cam.getDirection());
        }

        public int compare(Geometry o1, Geometry o2) {
            float d2;
            float d1 = this.distanceToCam(o1);
            if (d1 == (d2 = this.distanceToCam(o2))) {
                return 0;
            }
            if (d1 < d2) {
                return 1;
            }
            return -1;
        }
    }
}

