/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.ui.bp;

import com.simsilica.mblock.CellArray;
import mythruna.client.ui.edit.Edit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddCellsEdit
implements Edit {
    static Logger log = LoggerFactory.getLogger(AddCellsEdit.class);
    private CellArray target;
    private String name;
    private CellArray values;
    private CellArray undo;

    public AddCellsEdit(CellArray target, String name, CellArray values) {
        this.target = target;
        this.name = name;
        this.values = values;
    }

    @Override
    public String toDisplay() {
        return "add:" + this.name;
    }

    @Override
    public void doEdit() {
        this.undo = this.target.clone();
        int xSize = this.target.getSizeX();
        int ySize = this.target.getSizeY();
        int zSize = this.target.getSizeZ();
        for (int i = 0; i < xSize; ++i) {
            for (int j = 0; j < ySize; ++j) {
                for (int k = 0; k < zSize; ++k) {
                    int value = this.values.getCell(i, j, k, 0);
                    if (value == 0) continue;
                    this.target.setCell(i, j, k, value);
                }
            }
        }
    }

    @Override
    public void undoEdit() {
        if (this.undo != null) {
            this.target.set(this.undo);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.toDisplay() + "]";
    }
}

