/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mworld.db;

import com.simsilica.mblock.CellData;
import com.simsilica.mblock.LightUtils;
import com.simsilica.mworld.CellDataStack;
import com.simsilica.mworld.ColumnData;
import com.simsilica.mworld.LeafData;
import com.simsilica.mworld.LightData;
import com.simsilica.mworld.db.ColumnDb;
import com.simsilica.mworld.db.ColumnPostProcessor;
import com.simsilica.mworld.db.PostProcColumnDb;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InitialSunlightProcessor
implements ColumnPostProcessor {
    static Logger log = LoggerFactory.getLogger(InitialSunlightProcessor.class);
    private PostProcColumnDb parent;
    private ColumnDb delegate;

    @Override
    public void initialize(PostProcColumnDb parent) {
        this.parent = parent;
        this.delegate = parent.getDelegate();
    }

    @Override
    public void terminate() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean postProcess(ColumnData col) {
        if (col.hasGenerationFlag(2)) {
            return false;
        }
        if (log.isTraceEnabled()) {
            log.trace("postProcess(" + col + ")");
        }
        LeafData[] leafs = col.getLeafs();
        LightData[] light = col.getLighting();
        int size = leafs.length;
        boolean lit = true;
        int clearValue = LightUtils.DIRECT_SUN;
        for (int i = size - 1; i >= 0; --i) {
            if (lit && !leafs[i].isEmpty()) {
                lit = false;
                clearValue = -65536;
            }
            light[i].clear(clearValue);
        }
        CellDataStack blocks = new CellDataStack(32, col.getLeafs());
        CellDataStack lighting = new CellDataStack(32, col.getLighting());
        ColumnData columnData = col;
        synchronized (columnData) {
            long start = System.nanoTime();
            LightUtils.resetLighting((int)LightUtils.DIRECT_SUN, (CellData)blocks, (CellData)lighting, (int)0, (int)0, (int)0, (int)32, (int)lighting.getMaxY(), (int)32);
            long end = System.nanoTime();
            if (log.isTraceEnabled()) {
                log.trace(String.format("reset lighting in: %.02f ms", (double)(end - start) / 1000000.0));
            }
        }
        col.setGenerationFlag(2);
        return true;
    }
}

