/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mworld.view;

import com.jme3.app.Application;
import com.jme3.app.SimpleApplication;
import com.jme3.app.state.BaseAppState;
import com.jme3.bounding.BoundingBox;
import com.jme3.bounding.BoundingVolume;
import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.renderer.RenderManager;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.SceneGraphVisitor;
import com.jme3.scene.SceneGraphVisitorAdapter;
import com.jme3.scene.Spatial;
import com.jme3.texture.Image;
import com.jme3.texture.Texture;
import com.jme3.texture.Texture2D;
import com.jme3.texture.image.ColorSpace;
import com.jme3.util.BufferUtils;
import com.simsilica.lemur.LayerComparator;
import com.simsilica.lemur.core.VersionedHolder;
import com.simsilica.lemur.core.VersionedObject;
import com.simsilica.lemur.core.VersionedReference;
import com.simsilica.mathd.Grid;
import com.simsilica.mathd.Vec3d;
import com.simsilica.mathd.Vec3i;
import com.simsilica.mblock.geom.ColliderlessMesh;
import com.simsilica.mworld.ColumnId;
import com.simsilica.mworld.DataVersion;
import com.simsilica.mworld.TileId;
import com.simsilica.mworld.World;
import com.simsilica.mworld.geom.FanMeshBuilder;
import com.simsilica.mworld.tile.Resolution;
import com.simsilica.mworld.tile.TerrainImage;
import com.simsilica.mworld.tile.TerrainImageType;
import com.simsilica.mworld.tile.TileChangeEvent;
import com.simsilica.mworld.tile.TileListener;
import com.simsilica.mworld.view.FogSettings;
import com.simsilica.mworld.view.MaterialFactories;
import com.simsilica.mworld.view.ViewMask;
import com.simsilica.sim.Blackboard;
import com.simsilica.state.BlackboardState;
import com.simsilica.thread.Job;
import com.simsilica.thread.JobState;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TerrainState
extends BaseAppState {
    static Logger log = LoggerFactory.getLogger(TerrainState.class);
    private Node root = new Node("terrainRoot");
    private JobState workers;
    private JobState priorityWorkers;
    private Blackboard blackboard;
    private World world;
    private Vector2f mediumTerrainOffset = new Vector2f();
    private Vector2f farTerrainOffset = new Vector2f();
    private Geometry test;
    private Vector3f original;
    private VersionedReference<Vec3d> posRef;
    private Texture emptyTexture;
    private HiresLayer hiresLayer;
    private HiresLayer waterLayer;
    private ViewMask viewMask;
    private VersionedReference<Vec3i> maskCenter;
    private int radials = 1440;
    private boolean wireframe = false;
    private byte[] fill = new byte[]{0, 0, 0, 0};
    private boolean lightingEnabled = true;
    private FogSettings fogSettings;
    private VersionedReference<FogSettings> fogSettingsRef;
    private boolean waterEnabled = true;
    private double minStep = 1.0;
    private double growth = 1.0;
    private VersionedHolder<Integer> triangleCount = new VersionedHolder();
    private boolean xzLockedCamera = false;
    private boolean cellDebug = false;
    private Function<TerrainImageType, Material> materialFactory;
    private float horizontalLimit = 0.9f;
    private float verticalLimit = 0.99f;
    private int basicPriorityLevel = 200;
    private int highPriorityLevel = 100;
    boolean continuous = false;

    public TerrainState() {
        this(false);
    }

    public TerrainState(Blackboard blackboard) {
        this(false);
        this.blackboard = blackboard;
    }

    public TerrainState(boolean xzLockedCamera) {
        this.setEnabled(true);
        this.xzLockedCamera = xzLockedCamera;
    }

    public int getBasicPriorityLevel() {
        return this.basicPriorityLevel;
    }

    public int getHighPriorityLevel() {
        return this.highPriorityLevel;
    }

    public void setPriorityLevels(int basicPriorityLevel, int highPriorityLevel) {
        this.basicPriorityLevel = basicPriorityLevel;
        this.highPriorityLevel = highPriorityLevel;
    }

    public double getVisualRadius() {
        Vec3d pos = ((Vec3d)this.posRef.get()).clone();
        return this.hiresLayer.getVisualRadius(pos);
    }

    public double getNearestBlankDistance() {
        Vec3d pos = ((Vec3d)this.posRef.get()).clone();
        pos.y = 0.0;
        double min1 = this.hiresLayer.getNearestBlankDistance(pos);
        if (min1 == 0.0) {
            return 0.0;
        }
        double min2 = this.waterLayer.getNearestBlankDistance(pos);
        return Math.min(min1, min2);
    }

    public void setMaterialFactory(Function<TerrainImageType, Material> materialFactory) {
        this.materialFactory = materialFactory;
        if (this.hiresLayer != null) {
            this.hiresLayer.updateMaterial(materialFactory);
            this.waterLayer.updateMaterial(materialFactory);
        }
    }

    public Function<TerrainImageType, Material> getMaterialFactory() {
        return this.materialFactory;
    }

    public void setXzLockedCamera(boolean f) {
        this.xzLockedCamera = f;
    }

    public boolean isXzLockedCamera() {
        return this.xzLockedCamera;
    }

    public void setCellDebug(boolean f) {
        this.cellDebug = f;
    }

    public boolean getCellDebug() {
        return this.cellDebug;
    }

    public VersionedReference<Integer> getTriangleCount() {
        return this.triangleCount.createReference();
    }

    public void setWaterEnabled(boolean waterEnabled) {
        if (this.waterEnabled == waterEnabled) {
            return;
        }
        this.waterEnabled = waterEnabled;
        if (this.waterLayer != null) {
            this.waterLayer.setEnabled(waterEnabled);
        }
    }

    public boolean isWaterEnabled() {
        return this.waterEnabled;
    }

    public void setLightingEnabled(boolean lightingEnabled) {
        if (this.lightingEnabled == lightingEnabled) {
            return;
        }
        this.lightingEnabled = lightingEnabled;
        this.hiresLayer.setLightingEnabled(lightingEnabled);
        this.waterLayer.setLightingEnabled(lightingEnabled);
    }

    public boolean isLightingEnabled() {
        return this.lightingEnabled;
    }

    public void setFogSettings(FogSettings fogSettings) {
        this.fogSettings = fogSettings;
        this.fogSettingsRef = fogSettings == null ? null : fogSettings.createReference();
        this.resetFog();
    }

    public FogSettings getFogSettings() {
        return this.fogSettings;
    }

    protected int getFogDistance() {
        return this.fogSettings == null ? 0 : this.fogSettings.getFogDistance();
    }

    protected void resetFog() {
        if (this.root != null) {
            TerrainState.updateFogDistance((Spatial)this.root, this.getFogDistance(), -1.0f);
        }
    }

    public static void updateFogDistance(Spatial s, final float distance, final float clipDistance) {
        s.depthFirstTraversal((SceneGraphVisitor)new SceneGraphVisitorAdapter(){

            public void visit(Geometry geom) {
                Material mat = geom.getMaterial();
                if (mat.getParam("UseFog") == null) {
                    return;
                }
                if (distance > 0.0f) {
                    mat.setBoolean("UseFog", true);
                    mat.setFloat("ExpFog", 1.0f / distance);
                } else {
                    mat.setBoolean("UseFog", false);
                }
                if (clipDistance >= 0.0f && mat.getParam("ClipDistance") != null) {
                    mat.setFloat("ClipDistance", clipDistance);
                }
            }
        });
    }

    public void setWireframe(boolean wireframe) {
        if (this.wireframe == wireframe) {
            return;
        }
        this.wireframe = wireframe;
        if (this.hiresLayer != null) {
            this.hiresLayer.setWireframe(wireframe);
            this.waterLayer.setWireframe(wireframe);
        }
    }

    public boolean getWireframe() {
        return this.wireframe;
    }

    public void setHorizontalLimit(float limit) {
        if (this.horizontalLimit == limit) {
            return;
        }
        this.horizontalLimit = limit;
        if (this.hiresLayer != null) {
            this.hiresLayer.setUpnessRange(this.horizontalLimit, this.verticalLimit);
            this.waterLayer.setUpnessRange(this.horizontalLimit, this.verticalLimit);
        }
    }

    public float getHorizontalLimit() {
        return this.horizontalLimit;
    }

    public void setVerticalLimit(float limit) {
        if (this.verticalLimit == limit) {
            return;
        }
        this.verticalLimit = limit;
        if (this.hiresLayer != null) {
            this.hiresLayer.setUpnessRange(this.horizontalLimit, this.verticalLimit);
            this.waterLayer.setUpnessRange(this.horizontalLimit, this.verticalLimit);
        }
    }

    public float getVerticalLimit() {
        return this.verticalLimit;
    }

    public void setRadials(int radials) {
        if (this.radials == radials) {
            return;
        }
        this.radials = radials;
        this.regenerateGeometry();
    }

    public int getRadials() {
        return this.radials;
    }

    public void setMinStep(double minStep) {
        if (this.minStep == minStep) {
            return;
        }
        this.minStep = minStep;
        this.regenerateGeometry();
    }

    public double getMinStep() {
        return this.minStep;
    }

    public void setGrowth(double growth) {
        if (this.growth == growth) {
            return;
        }
        this.growth = growth;
        this.regenerateGeometry();
    }

    public double getGrowth() {
        return this.growth;
    }

    protected int getTotalTriangleCount() {
        int result = this.hiresLayer.getTriangleCount();
        if (this.waterEnabled) {
            result += this.waterLayer.getTriangleCount();
        }
        return result;
    }

    protected void regenerateGeometry() {
        this.hiresLayer.setRadials(this.radials);
        this.hiresLayer.setMinStep(this.minStep);
        this.hiresLayer.setGrowth(this.growth);
        this.waterLayer.setRadials(this.radials / 2);
        this.waterLayer.setMinStep(this.minStep);
        this.waterLayer.setGrowth(this.growth * 10.0);
        this.hiresLayer.regenerateMesh();
        this.waterLayer.regenerateMesh();
        this.triangleCount.setObject((Object)this.getTotalTriangleCount());
    }

    protected void setViewMask(ViewMask viewMask) {
        this.viewMask = viewMask;
        this.maskCenter = viewMask.createReference();
        if (this.hiresLayer != null) {
            this.hiresLayer.updateViewMask();
            this.waterLayer.updateViewMask();
        }
    }

    protected void initialize(Application app) {
        if (this.blackboard == null) {
            this.blackboard = ((BlackboardState)this.getState(BlackboardState.class, true)).getBlackboard();
        }
        this.world = (World)this.blackboard.get(World.class);
        this.blackboard.onInitialize(ViewMask.class, mask -> this.setViewMask((ViewMask)mask));
        this.blackboard.onInitialize(FogSettings.class, fogSettings -> this.setFogSettings((FogSettings)fogSettings));
        this.workers = (JobState)this.getState("regularWorkers", JobState.class);
        if (this.workers == null) {
            this.workers = (JobState)this.getState(JobState.class, true);
        }
        this.priorityWorkers = (JobState)this.getState("priorityWorkers", JobState.class);
        if (this.priorityWorkers == null) {
            this.priorityWorkers = (JobState)this.getState(JobState.class, true);
        }
        this.emptyTexture = this.createEmptyTexture();
        this.posRef = ((VersionedObject)this.blackboard.get("position")).createReference();
        if (this.getMaterialFactory() == null) {
            log.warn("No material factory configured.  Using a default coloredTerrainMaterial()");
            ColorRGBA groundColor = new ColorRGBA(0.15f, 0.25f, 0.1f, 1.0f);
            ColorRGBA waterColor = new ColorRGBA(0.41960785f, 0.5529412f, 0.8509804f, 0.9f);
            this.setMaterialFactory(MaterialFactories.coloredTerrainMaterial(this.getApplication(), groundColor, waterColor));
        }
        this.hiresLayer = new HiresLayer(TerrainImageType.Terrain, this.radials, this.minStep, this.growth);
        this.waterLayer = new HiresLayer(TerrainImageType.Fluid, this.radials / 2, this.minStep, this.growth * 10.0);
        if (!this.waterEnabled) {
            this.waterLayer.setEnabled(this.waterEnabled);
        }
        this.waterLayer.setSpatialOffset(-0.25f);
        this.triangleCount.setObject((Object)this.getTotalTriangleCount());
    }

    private Texture createTexture(TerrainImage terrain) {
        System.out.println("Creating texture for:" + terrain);
        int imageSize = 1024;
        ByteBuffer data = BufferUtils.createByteBuffer((int)(imageSize * imageSize * 4));
        this.writeTileToImage(terrain, data, 0, 0);
        Image image = new Image(Image.Format.ARGB8, imageSize, imageSize, data, ColorSpace.Linear);
        Texture2D texture = new Texture2D(image);
        return texture;
    }

    private Texture createEmptyTexture() {
        int imageSize = 1;
        ByteBuffer data = BufferUtils.createByteBuffer((int)(imageSize * imageSize * 4));
        Image image = new Image(Image.Format.ARGB8, imageSize, imageSize, data, ColorSpace.Linear);
        Texture2D texture = new Texture2D(image);
        return texture;
    }

    private void fill(ByteBuffer data, byte ... bytes) {
        data.position(0);
        while (data.remaining() > 0) {
            data.put(bytes);
        }
    }

    private void writeTileToImage(TerrainImage terrain, ByteBuffer data, int xTarget, int yTarget) {
        int pos = xTarget + yTarget * 1024;
        for (int y = 0; y < terrain.getSize(); ++y) {
            data.position(pos * 4);
            for (int x = 0; x < terrain.getSize(); ++x) {
                short val = terrain.getElevation(x, y);
                int elev = val & 0x3FF;
                int type = terrain.getType(x, y);
                if (this.cellDebug) {
                    if (x == 0 || y == 0) {
                        type = 96;
                    } else if (x % 32 == 0 || y % 32 == 0) {
                        type = 255;
                    }
                }
                int hi = elev / 255;
                int lo = elev % 255;
                byte r = (byte)type;
                byte light = terrain.getLight(x, y);
                byte g = (byte)((0.5 + (double)light / 32.0) * 255.0);
                byte b = (byte)hi;
                byte a = (byte)lo;
                data.put(a).put(r).put(g).put(b);
                ++pos;
            }
            pos += 1024 - terrain.getSize();
        }
    }

    private void writeBlankTileToImage(int size, ByteBuffer data, int xTarget, int yTarget) {
        int pos = xTarget + yTarget * 1024;
        for (int y = 0; y < size; ++y) {
            data.position(pos * 4);
            for (int x = 0; x < size; ++x) {
                data.put((byte)0).put((byte)0).put((byte)0).put((byte)0);
                ++pos;
            }
            pos += 1024 - size;
        }
    }

    protected void cleanup(Application app) {
    }

    protected void onEnable() {
        ((SimpleApplication)this.getApplication()).getRootNode().attachChild((Spatial)this.root);
    }

    protected void onDisable() {
        this.root.removeFromParent();
    }

    public void update(float tpf) {
        if (this.posRef.update()) {
            Vec3d pos = (Vec3d)this.posRef.get();
            if (this.continuous) {
                this.hiresLayer.setPosition(pos);
                this.hiresLayer.setMaskCenter(pos, (Vec3i)this.maskCenter.get());
                this.waterLayer.setPosition(pos);
                this.waterLayer.setMaskCenter(pos, (Vec3i)this.maskCenter.get());
            } else {
                Vec3d columnPos = ColumnId.fromWorld(pos).getWorld(null).toVec3d();
                columnPos.x += 16.0;
                columnPos.z += 16.0;
                if (this.xzLockedCamera) {
                    Vec3d offset = pos.subtract(columnPos);
                    this.root.setLocalTranslation((float)(-offset.x), 0.0f, (float)(-offset.z));
                } else {
                    this.root.setLocalTranslation(16.0f, 0.0f, 16.0f);
                }
                this.hiresLayer.setPosition(columnPos);
                this.hiresLayer.setMaskCenter(columnPos, (Vec3i)this.maskCenter.get());
                this.waterLayer.setPosition(columnPos);
                this.waterLayer.setMaskCenter(columnPos, (Vec3i)this.maskCenter.get());
            }
        }
        if (this.fogSettingsRef != null && this.fogSettingsRef.update()) {
            this.resetFog();
        }
    }

    public void render(RenderManager rm) {
        Vec3d pos = (Vec3d)this.posRef.get();
        if (this.continuous) {
            this.hiresLayer.setMaskCenter(pos, (Vec3i)this.maskCenter.get());
            this.waterLayer.setMaskCenter(pos, (Vec3i)this.maskCenter.get());
        } else {
            Vec3d columnPos = ColumnId.fromWorld(pos).getWorld(null).toVec3d();
            columnPos.x += 16.0;
            columnPos.z += 16.0;
            this.hiresLayer.setMaskCenter(columnPos, (Vec3i)this.maskCenter.get());
            this.waterLayer.setMaskCenter(columnPos, (Vec3i)this.maskCenter.get());
        }
    }

    private class HiresImageTile
    implements Job {
        TileId tileId;
        String key;
        int xCell;
        int yCell;
        int zCell;
        TerrainImageType type;
        TerrainImage terrain;
        Material material;
        volatile DataVersion tileVersion;
        volatile Texture texture;
        volatile String parameter;
        volatile boolean visible = true;
        volatile boolean queued;
        boolean rendered = false;

        public HiresImageTile(TerrainImageType type, TileId tileId, String key, Material material, Texture empty, int xCell, int yCell, int zCell) {
            if (log.isTraceEnabled()) {
                log.trace("new HiresImageTile(" + tileId + ")");
            }
            this.type = type;
            this.tileId = tileId;
            this.key = key;
            this.material = material;
            this.texture = empty;
            this.xCell = xCell;
            this.yCell = yCell;
            this.zCell = zCell;
        }

        public boolean isOlderThan(long version) {
            if (this.tileVersion == null) {
                return true;
            }
            return this.tileVersion.getVersion() < version;
        }

        public void setParameter(String parameter) {
            this.parameter = parameter;
            if (this.texture != null) {
                this.material.setTexture(parameter, this.texture);
            }
        }

        public void release() {
            this.visible = false;
        }

        public void runOnWorker() {
            this.queued = false;
            if (!this.visible) {
                return;
            }
            this.terrain = TerrainState.this.world.getTerrainImage(TileId.fromCell(this.xCell, this.yCell, this.zCell), this.type, Resolution.High);
            this.tileVersion = this.terrain.getVersion().clone();
            if (log.isTraceEnabled()) {
                log.trace("Refreshing tile:" + this + "  version:" + this.tileVersion);
            }
            this.texture = TerrainState.this.createTexture(this.terrain);
        }

        public double runOnUpdate() {
            if (!this.visible) {
                return 0.0;
            }
            if (this.parameter != null) {
                this.material.setTexture(this.parameter, this.texture);
            }
            this.rendered = true;
            return 0.0;
        }

        public String toString() {
            return "HiresImageTile[" + this.xCell + ", " + this.zCell + "]";
        }
    }

    private class HiresLayer
    implements TileListener {
        private Material material;
        private Vector2f terrainOffset = new Vector2f();
        private Vector3f maskOffset = new Vector3f();
        private TerrainImageType type;
        private HiresImageTile[][] imageTiles = new HiresImageTile[2][2];
        private Grid subGrid = new Grid(512, 0, 512);
        private Vec3i gridCenter = new Vec3i();
        private Vec3i lastCorner = new Vec3i();
        private Map<String, HiresImageTile> tileCache = new HashMap<String, HiresImageTile>();
        private Geometry center;
        private Geometry ring;
        private float spatialOffset = 0.0f;
        private int radials;
        private double minStep;
        private double growth;
        private Vec3i minCorner = new Vec3i();
        private Vec3i maxCorner = new Vec3i();

        public HiresLayer(TerrainImageType type, int radials, double minStep, double growth) {
            this.type = type;
            this.radials = radials;
            this.minStep = minStep;
            this.growth = growth;
            boolean water = type == TerrainImageType.Fluid;
            ColliderlessMesh fan = new FanMeshBuilder().far(32).radials(radials / 2).minStep(minStep).growthFactor(growth).build();
            Geometry geom = this.center = new Geometry("hiresFan", (Mesh)fan);
            LayerComparator.setLayer((Spatial)geom, (int)(water ? 2 : 1));
            geom.center();
            geom.setModelBound((BoundingVolume)new BoundingBox(new Vector3f(-10000.0f, -100.0f, -10000.0f), new Vector3f(10000.0f, 10000.0f, 10000.0f)));
            TerrainState.this.root.attachChild((Spatial)geom);
            fan = new FanMeshBuilder().near(32).far(512).radials(radials).minStep(minStep).growthFactor(growth).build();
            geom = this.ring = new Geometry("hiresFan", (Mesh)fan);
            LayerComparator.setLayer((Spatial)geom, (int)(water ? 2 : 1));
            geom.center();
            geom.setModelBound((BoundingVolume)new BoundingBox(new Vector3f(-10000.0f, -100.0f, -10000.0f), new Vector3f(10000.0f, 10000.0f, 10000.0f)));
            TerrainState.this.root.attachChild((Spatial)geom);
            this.updateMaterial(TerrainState.this.getMaterialFactory());
            TerrainState.this.world.addTileListener(this);
        }

        public double getVisualRadius(Vec3d pos) {
            if (pos.x < (double)this.minCorner.x || pos.x >= (double)this.maxCorner.x || pos.z < (double)this.minCorner.z || pos.z >= (double)this.maxCorner.z) {
                return 0.0;
            }
            double xDist = Math.min(pos.x - (double)this.minCorner.x, (double)this.maxCorner.x - pos.x);
            double zDist = Math.min(pos.z - (double)this.minCorner.z, (double)this.maxCorner.z - pos.z);
            return Math.min(xDist, zDist);
        }

        public double getNearestBlankDistance(Vec3d pos) {
            double minDist = this.getVisualRadius(pos);
            if (minDist == 0.0) {
                return 0.0;
            }
            Vec3i world = this.subGrid.cellToWorld(this.gridCenter.x + 1, 0, this.gridCenter.z + 1);
            Vec3i max = TileId.GRID.worldToCell(world.toVec3d());
            world = this.subGrid.cellToWorld(this.gridCenter.x - 1, 0, this.gridCenter.z - 1);
            Vec3i min = TileId.GRID.worldToCell(world.toVec3d());
            TileId posTile = TileId.fromWorld(pos);
            Vec3i base = posTile.getWorld(null);
            Vec3i offset = pos.subtract(base.add(512, 0, 512)).floor();
            double minDistSq = minDist * minDist;
            for (int i = 0; i < 2; ++i) {
                for (int j = 0; j < 2; ++j) {
                    double dSq;
                    TileId id;
                    HiresImageTile tile = this.imageTiles[i][j];
                    if (tile != null && tile.rendered) continue;
                    if (tile == null) {
                        Vec3i cell = new Vec3i(min.x + i, min.y, min.z + j);
                        id = TileId.fromCell(cell.x, cell.y, cell.z);
                    } else {
                        id = tile.tileId;
                    }
                    if (posTile.equals(id)) {
                        return 0.0;
                    }
                    Vec3i delta = id.getWorld(null).subtractLocal(base);
                    if (delta.x != 0) {
                        delta.x -= offset.x;
                    }
                    if (delta.z != 0) {
                        delta.z -= offset.z;
                    }
                    if (!((dSq = delta.lengthSq()) < minDistSq)) continue;
                    minDistSq = dSq;
                }
            }
            return Math.sqrt(minDistSq);
        }

        public void setSpatialOffset(float spatialOffset) {
            this.spatialOffset = spatialOffset;
            this.resetOffset();
        }

        protected void resetOffset() {
            Vector3f loc = this.center.getLocalTranslation();
            loc.y = this.spatialOffset;
            this.center.setLocalTranslation(loc);
            loc = this.ring.getLocalTranslation();
            loc.y = this.spatialOffset;
            this.ring.setLocalTranslation(loc);
        }

        public void updateMaterial(Function<TerrainImageType, Material> materialFactory) {
            Material mat = this.material = materialFactory.apply(this.type);
            if (TerrainState.this.fogSettings != null) {
                TerrainState.this.fogSettings.apply(mat);
            }
            mat.setVector2("TerrainOffset", this.terrainOffset);
            this.material.setFloat("TerrainSize", 1024.0f);
            mat.getAdditionalRenderState().setWireframe(TerrainState.this.wireframe);
            this.updateViewMask();
            this.material.setTexture("DiffuseMap1", TerrainState.this.emptyTexture);
            this.material.setTexture("DiffuseMap2", TerrainState.this.emptyTexture);
            this.material.setTexture("DiffuseMap3", TerrainState.this.emptyTexture);
            this.material.setTexture("DiffuseMap4", TerrainState.this.emptyTexture);
            this.setUpnessRange(TerrainState.this.horizontalLimit, TerrainState.this.verticalLimit);
            if (this.center != null) {
                this.center.setMaterial(this.material);
                this.ring.setMaterial(this.material);
            }
        }

        public void updateViewMask() {
            if (TerrainState.this.viewMask != null) {
                this.material.setTexture("MaskArray", TerrainState.this.viewMask.getMaskTextures());
                this.material.setVector3("MaskOffset", this.maskOffset);
                this.material.setFloat("ViewMaskRadiusXZ", (float)((TerrainState)TerrainState.this).viewMask.getViewRadius().x);
                this.material.setFloat("ViewMaskRadiusY", (float)((TerrainState)TerrainState.this).viewMask.getViewRadius().y);
            }
        }

        public void setUpnessRange(float min, float max) {
            if (min < max) {
                this.material.setFloat("HorizontalLimit", min);
                this.material.setFloat("VerticalLimit", max);
            } else {
                this.material.setFloat("HorizontalLimit", min);
                this.material.setFloat("VerticalLimit", min + 1.0E-4f);
            }
        }

        public void setEnabled(boolean enabled) {
            if (enabled) {
                if (this.center.getParent() == null) {
                    TerrainState.this.root.attachChild((Spatial)this.center);
                    TerrainState.this.root.attachChild((Spatial)this.ring);
                }
            } else {
                this.center.removeFromParent();
                this.ring.removeFromParent();
            }
        }

        public int getTriangleCount() {
            return this.center.getTriangleCount() + this.ring.getTriangleCount();
        }

        public void setRadials(int radials) {
            this.radials = radials;
        }

        public void setMinStep(double minStep) {
            this.minStep = minStep;
        }

        public void setGrowth(double growth) {
            this.growth = growth;
        }

        public void regenerateMesh() {
            ColliderlessMesh fan = new FanMeshBuilder().far(32).radials(this.radials / 2).minStep(this.minStep).growthFactor(this.growth).build();
            this.center.setMesh((Mesh)fan);
            this.center.center();
            this.center.setModelBound((BoundingVolume)new BoundingBox(new Vector3f(-10000.0f, -100.0f, -10000.0f), new Vector3f(10000.0f, 10000.0f, 10000.0f)));
            fan = new FanMeshBuilder().near(32).far(512).radials(this.radials).minStep(this.minStep).growthFactor(this.growth).build();
            this.ring.setMesh((Mesh)fan);
            this.ring.center();
            this.ring.setModelBound((BoundingVolume)new BoundingBox(new Vector3f(-10000.0f, -100.0f, -10000.0f), new Vector3f(10000.0f, 10000.0f, 10000.0f)));
            this.resetOffset();
        }

        public void setLightingEnabled(boolean lightingEnabled) {
            this.center.getMaterial().setFloat("LocalLightStrength", lightingEnabled ? 0.8f : 0.0f);
        }

        public void setWireframe(boolean wireframe) {
            this.center.getMaterial().getAdditionalRenderState().setWireframe(wireframe);
        }

        @Override
        public void tileChanged(TileChangeEvent event) {
            if (event.getResolution() != Resolution.High) {
                return;
            }
            if (log.isDebugEnabled()) {
                log.debug("Terrain changed:" + event);
            }
            TileId id = event.getTileId();
            long version = event.getDataVersion();
            for (HiresImageTile it : this.tileCache.values()) {
                if (it.tileId.getId() != id.getId() || !it.isOlderThan(version) || TerrainState.this.workers.isQueued((Job)it) || version == 0L) continue;
                if (log.isTraceEnabled()) {
                    log.trace("Updating:" + it);
                }
                if (TerrainState.this.priorityWorkers == TerrainState.this.workers) {
                    it.queued = true;
                }
                TerrainState.this.priorityWorkers.execute((Job)it, -1);
            }
        }

        public void setPosition(Vec3d pos) {
            this.updateTerrainTiles(pos);
            Vec3i world = TileId.GRID.cellToWorld(this.lastCorner);
            this.terrainOffset.x = (float)(pos.x - 512.0 - (double)world.x);
            this.terrainOffset.y = (float)(pos.z - 512.0 - (double)world.z);
        }

        public void setMaskCenter(Vec3d pos, Vec3i center) {
            this.maskOffset.x = (float)((double)center.x - pos.x) + 512.0f;
            this.maskOffset.y = center.y;
            this.maskOffset.z = (float)((double)center.z - pos.z) + 512.0f;
        }

        protected void updateTerrainTiles(Vec3d pos) {
            Vec3i sg = this.subGrid.worldToCell(pos, null);
            if (!this.tileCache.isEmpty() && sg.x == this.gridCenter.x && sg.z == this.gridCenter.z) {
                return;
            }
            this.gridCenter.set(sg.x, 0, sg.z);
            Vec3i world = this.subGrid.cellToWorld(this.gridCenter.x + 1, 0, this.gridCenter.z + 1);
            Vec3i max = TileId.GRID.worldToCell(world.toVec3d());
            world = this.subGrid.cellToWorld(this.gridCenter.x - 1, 0, this.gridCenter.z - 1);
            Vec3i min = TileId.GRID.worldToCell(world.toVec3d());
            TileId.fromCell(min).getWorld(this.minCorner);
            TileId.fromCell(max).getWorld(this.maxCorner);
            this.maxCorner.addLocal(1024, 0, 1024);
            if (!this.tileCache.isEmpty() && min.equals((Object)this.lastCorner)) {
                return;
            }
            this.lastCorner.set(min);
            if (log.isTraceEnabled()) {
                log.trace("min:" + min + "  max:" + max);
            }
            TileId centerTile = TileId.fromWorld(pos);
            for (int i = 0; i < 2; ++i) {
                for (int j = 0; j < 2; ++j) {
                    Vec3i cell = new Vec3i(min.x + i, min.y, min.z + j);
                    String key = cell.x + "x" + cell.z;
                    TileId id = TileId.fromCell(cell.x, cell.y, cell.z);
                    HiresImageTile imageTile = this.tileCache.remove(key);
                    if (imageTile == null) {
                        imageTile = new HiresImageTile(this.type, id, key, this.material, TerrainState.this.emptyTexture, cell.x, cell.y, cell.z);
                        if (log.isTraceEnabled()) {
                            log.trace("Executing:" + imageTile);
                        }
                        if (!TerrainState.this.priorityWorkers.isQueued((Job)imageTile)) {
                            imageTile.queued = true;
                            int priority = TerrainState.this.basicPriorityLevel;
                            if (id.equals(centerTile)) {
                                priority = TerrainState.this.highPriorityLevel;
                            }
                            TerrainState.this.workers.execute((Job)imageTile, priority);
                        }
                    }
                    this.imageTiles[i][j] = imageTile;
                }
            }
            for (HiresImageTile tile : this.tileCache.values()) {
                if (log.isTraceEnabled()) {
                    log.trace("releasing:" + tile);
                }
                tile.release();
                if (!tile.queued) continue;
                if (!TerrainState.this.workers.cancel((Job)tile)) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug("Tile job not canceled for:" + tile.tileId);
                    continue;
                }
                tile.queued = false;
            }
            this.tileCache.clear();
            for (int i = 0; i < 2; ++i) {
                for (int j = 0; j < 2; ++j) {
                    HiresImageTile tile = this.imageTiles[i][j];
                    this.tileCache.put(tile.key, tile);
                }
            }
            this.imageTiles[0][0].setParameter("DiffuseMap1");
            this.imageTiles[1][0].setParameter("DiffuseMap2");
            this.imageTiles[0][1].setParameter("DiffuseMap3");
            this.imageTiles[1][1].setParameter("DiffuseMap4");
        }
    }
}

