/*
 * Decompiled with CFR 0.152.
 */
package mythruna.es;

import com.google.common.base.MoreObjects;
import com.simsilica.es.EntityComponent;
import com.simsilica.es.EntityData;
import com.simsilica.es.EntityId;
import com.simsilica.es.PersistentComponent;
import mythruna.world.WorldTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScheduledAction
implements EntityComponent,
PersistentComponent {
    static Logger log = LoggerFactory.getLogger(ScheduledAction.class);
    private long atTime;
    private EntityId target;
    private int actionId;

    private ScheduledAction() {
    }

    public ScheduledAction(long atTime, EntityId target, int actionId) {
        this.atTime = atTime;
        this.target = target;
        this.actionId = actionId;
    }

    public static ScheduledAction create(WorldTime atTime, EntityId target, String action, EntityData ed) {
        return ScheduledAction.create(atTime.getSimTime(), target, action, ed);
    }

    public static ScheduledAction create(long atTime, EntityId target, String action, EntityData ed) {
        int id = ed.getStrings().getStringId(action, false);
        if (id < 0) {
            id = ed.getStrings().getStringId(action, true);
        }
        return new ScheduledAction(atTime, target, id);
    }

    public long getAtTime() {
        return this.atTime;
    }

    public EntityId getTarget() {
        return this.target;
    }

    public int getActionId() {
        return this.actionId;
    }

    public String getAction(EntityData ed) {
        return ed.getStrings().getString(this.actionId);
    }

    public String toString() {
        return this.toString(null);
    }

    public String toString(EntityData ed) {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)this.getClass().getSimpleName()).add("atTime", this.atTime).add("target", (Object)this.target);
        if (ed != null) {
            helper.add("action", (Object)ed.getStrings().getString(this.actionId));
        } else {
            helper.add("actionId", this.actionId);
        }
        return helper.toString();
    }
}

