/*
 * Decompiled with CFR 0.152.
 */
package mythruna.sim;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SwingMotion {
    static Logger log = LoggerFactory.getLogger(SwingMotion.class);
    private State state;
    private double time;
    private double swingTime;
    private double restitution;
    private double rampUp;
    private double leadIn;
    private double flip;

    public SwingMotion(double rampUp, double leadIn, double flipBack, double restitution) {
        this.rampUp = rampUp;
        this.leadIn = leadIn;
        this.flip = flipBack;
        this.restitution = restitution;
        this.reset();
    }

    public void reset() {
        this.reset(State.RampUp);
    }

    protected void reset(State state) {
        this.time = 0.0;
        this.swingTime = 0.0;
        this.state = state;
    }

    public double getStrength() {
        switch (this.state) {
            case Swing: {
                return this.swingTime;
            }
        }
        return 0.0;
    }

    public double getLeadInPercent() {
        if (this.time > this.leadIn) {
            return 1.0;
        }
        return this.time / this.leadIn;
    }

    public double getSwingTime() {
        double x = this.swingTime;
        if (x < 1.0) {
            x *= x;
        } else if (x > 1.0) {
            x = 2.0 - x;
            x *= x;
            x = 2.0 - x;
        }
        return x;
    }

    public void blocked() {
        switch (this.state) {
            case RampUp: {
                this.reset();
                break;
            }
            case LeadIn: {
                this.reset();
                break;
            }
            case Swing: {
                this.state = State.Recoil;
                this.swingTime = 2.0 - this.swingTime;
                this.swingTime += this.restitution;
                if (!(this.swingTime > 2.0)) break;
                this.swingTime = 2.0;
                break;
            }
            case Recovery: {
                this.state = State.Stalled;
                this.swingTime -= this.restitution;
                if (!(this.swingTime <= 1.0)) break;
                this.swingTime = 1.0;
                break;
            }
            case Recoil: {
                break;
            }
        }
    }

    public void update(double step) {
        this.time += step;
        switch (this.state) {
            case RampUp: {
                if (!(this.time > this.rampUp)) break;
                this.state = State.LeadIn;
                this.swingTime = 0.0;
                break;
            }
            case LeadIn: {
                if (!(this.time > this.leadIn)) break;
                this.state = State.Swing;
                this.swingTime = 0.0;
                break;
            }
            case Swing: {
                this.swingTime += step;
                if (!(this.swingTime > 1.0)) break;
                this.state = State.Recovery;
                break;
            }
            case Recovery: 
            case Recoil: {
                this.swingTime += step;
                break;
            }
            case Stalled: {
                this.swingTime -= step;
                if (!(this.swingTime <= 1.0)) break;
                this.state = State.Recovery;
            }
        }
        if (this.swingTime >= 2.0 - this.flip) {
            switch (this.state) {
                case Recovery: {
                    this.reset(State.Swing);
                    this.time = this.leadIn;
                    break;
                }
                case Recoil: {
                    this.reset(State.Swing);
                    this.time = this.leadIn + this.flip;
                    this.swingTime = this.flip;
                    break;
                }
                default: {
                    this.reset();
                    return;
                }
            }
        }
    }

    private static enum State {
        RampUp,
        LeadIn,
        Swing,
        Recovery,
        Recoil,
        Stalled;

    }
}

