/*
 * Decompiled with CFR 0.152.
 */
package mythruna.sim.ai;

import com.google.common.base.MoreObjects;
import com.simsilica.bpos.BodyPosition;
import com.simsilica.es.EntityData;
import com.simsilica.es.EntityId;
import com.simsilica.mathd.Quatd;
import com.simsilica.mathd.Vec3d;
import mythruna.sim.ai.Mob;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BodyPositionMob
implements Mob {
    static Logger log = LoggerFactory.getLogger(BodyPositionMob.class);
    private final EntityId entityId;
    private final BodyPosition bpos;

    public BodyPositionMob(EntityId entityId, BodyPosition bpos) {
        this.entityId = entityId;
        this.bpos = bpos;
    }

    public static BodyPositionMob create(EntityData ed, EntityId id) {
        BodyPosition bodyPosition = (BodyPosition)ed.getComponent(id, BodyPosition.class);
        return bodyPosition == null ? null : new BodyPositionMob(id, bodyPosition);
    }

    @Override
    public EntityId getEntityId() {
        return this.entityId;
    }

    @Override
    public Vec3d getLocation() {
        return this.bpos.getLastLocation();
    }

    @Override
    public Quatd getOrientation() {
        return this.bpos.getLastOrientation();
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)this.getClass().getSimpleName()).add("entityId", (Object)this.entityId).add("location", (Object)this.getLocation()).add("orientation", (Object)this.getOrientation()).toString();
    }
}

