/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.namegen;

import com.simsilica.namegen.Cluster;
import com.simsilica.namegen.ClusterPair;
import com.simsilica.namegen.ClusterType;
import java.io.Serializable;
import java.util.Map;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Branches
implements Serializable {
    static Logger log = LoggerFactory.getLogger(Branches.class);
    private static final long serialVersionUID = 42L;
    private ClusterPair parent;
    private Map<Cluster, Integer> next = new TreeMap<Cluster, Integer>();
    private int total;
    private boolean hasTerminator;

    private Branches() {
    }

    public Branches(ClusterPair parent) {
        this.parent = parent;
    }

    public ClusterPair getParent() {
        return this.parent;
    }

    public boolean hasTerminator() {
        return this.hasTerminator;
    }

    public void addNext(Cluster c) {
        Integer val;
        if (c.getType() == ClusterType.End) {
            this.hasTerminator = true;
        }
        if ((val = this.next.get(c)) == null) {
            this.next.put(c, 1);
        } else {
            this.next.put(c, val + 1);
        }
        ++this.total;
    }

    public Map<Cluster, Integer> getChildren() {
        return this.next;
    }

    public Cluster getNext(double index) {
        int skip = (int)(index * (double)this.total);
        for (Map.Entry<Cluster, Integer> entry : this.next.entrySet()) {
            if ((skip -= entry.getValue().intValue()) >= 0) continue;
            return entry.getKey();
        }
        return null;
    }

    public Cluster getNext(double index, boolean skipTerminator) {
        int skip = (int)(index * (double)this.total);
        for (Map.Entry<Cluster, Integer> entry : this.next.entrySet()) {
            if (skipTerminator && entry.getKey().getType() == ClusterType.End || (skip -= entry.getValue().intValue()) >= 0) continue;
            return entry.getKey();
        }
        if (skipTerminator) {
            for (Map.Entry<Cluster, Integer> entry : this.next.entrySet()) {
                if (entry.getKey().getType() == ClusterType.End) continue;
                return entry.getKey();
            }
        }
        return null;
    }

    public String toString() {
        return "[parent:" + this.parent + ", numChildren:" + this.next.size() + "]";
    }
}

