
import com.simsilica.crig.*;
import com.simsilica.crig.jme.*;
import com.jme3.math.*;
import com.jme3.scene.*;

import com.simsilica.lemur.GuiGlobals;

VariationHandler skinHandler = { rig, name, index ->
    log.info("set skin variation:" + name + " = " + index + " for:" + rig);
    log.info("spatial:" + rig.animComposer.spatial);

    rig.animComposer.spatial.depthFirstTraversal(new SceneGraphVisitorAdapter() {
        public void visit( Geometry geom ) {
            log.info("visit(" + geom + ")");
            def mat = geom.getMaterial();
            log.info("material:" + mat);
            if( "Skin" == mat.name ) {
                def row = (int)(index / 4);
                def col = index % 4;
                def offset = new Vector2f((float)(col * 0.25), (float)(row * 0.25));
                log.info("Setting texture offset to:" + offset);
                mat.setVector2("TextureOffset", offset);
            }
        }
    });

    return true;
};

rigType.setVariationHandler("skin", skinHandler);



