/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.ui.item;

import com.jme3.app.Application;
import com.jme3.app.state.BaseAppState;
import com.jme3.scene.Spatial;
import com.simsilica.es.Entity;
import com.simsilica.es.EntityComponent;
import com.simsilica.es.EntityContainer;
import com.simsilica.es.EntityData;
import com.simsilica.es.EntityId;
import com.simsilica.es.Filters;
import com.simsilica.ext.mphys.ShapeInfo;
import com.simsilica.mathd.Vec3d;
import com.simsilica.mathd.Vec3i;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import mythruna.client.BackgroundRetrieverState;
import mythruna.client.GameSessionState;
import mythruna.client.ui.item.ContainerSection;
import mythruna.client.ui.item.Item;
import mythruna.client.ui.item.ItemContainer;
import mythruna.client.ui.item.ItemViewState;
import mythruna.es.ContainedIn;
import mythruna.es.ObjectName;
import mythruna.item.InventorySize2d;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContainerManagementState
extends BaseAppState {
    static Logger log = LoggerFactory.getLogger(ContainerManagementState.class);
    private EntityData ed;
    private ItemViewState itemViews;
    private BackgroundRetrieverState retriever;
    private Map<EntityId, RootManager> rootIndex = new HashMap<EntityId, RootManager>();
    private Map<EntityId, TreeNode> nodes = new HashMap<EntityId, TreeNode>();
    private BiConsumer<ShapeInfo, Consumer<Spatial>> shapeResolver;
    private BiConsumer<EntityId, Consumer<InventorySize2d>> itemSizeResolver;
    private BiConsumer<EntityId, Consumer<InventorySize2d>> containerSizeResolver;

    public ContainerManagementState() {
    }

    public ContainerManagementState(EntityData ed) {
        this.ed = ed;
    }

    public void setShapeResolver(BiConsumer<ShapeInfo, Consumer<Spatial>> shapeResolver) {
        this.shapeResolver = shapeResolver;
    }

    public void setItemSizeResolver(BiConsumer<EntityId, Consumer<InventorySize2d>> itemSizeResolver) {
        this.itemSizeResolver = itemSizeResolver;
    }

    public void setContainerSizeResolver(BiConsumer<EntityId, Consumer<InventorySize2d>> containerSizeResolver) {
        this.containerSizeResolver = containerSizeResolver;
    }

    public void addContainerRoot(EntityId root) {
        RootManager manager = this.rootIndex.get(root);
        if (manager != null) {
            return;
        }
        manager = new RootManager(this, this.ed, root);
        this.rootIndex.put(root, manager);
        if (this.itemViews != null) {
            manager.start();
        }
    }

    protected void initialize(Application app) {
        log.info("initialize()");
        if (this.ed == null) {
            this.ed = ((GameSessionState)this.getState(GameSessionState.class, true)).getEntityData();
        }
        this.itemViews = (ItemViewState)this.getState(ItemViewState.class, true);
        this.retriever = (BackgroundRetrieverState)this.getState(BackgroundRetrieverState.class, true);
    }

    protected void cleanup(Application app) {
    }

    protected void onEnable() {
        log.info("onEnable()");
        for (RootManager manager : this.rootIndex.values()) {
            manager.start();
        }
    }

    protected void onDisable() {
        for (RootManager manager : this.rootIndex.values()) {
            log.info("--------manager:" + manager);
            this.dump("", manager.tree.rootNode);
            manager.stop();
        }
    }

    public void update(float tpf) {
        for (RootManager manager : this.rootIndex.values()) {
            manager.update();
        }
    }

    protected void dump(String indent, TreeNode node) {
        log.info(indent + node);
        for (TreeNode child : node.children) {
            this.dump(indent + "  ", child);
        }
    }

    protected TreeNode getTreeNode(EntityId id, boolean create) {
        TreeNode result = this.nodes.get(id);
        if (result == null && create) {
            result = new TreeNode(this, id);
            this.nodes.put(id, result);
        }
        return result;
    }

    private class RootManager {
        private EntityId rootId;
        private TreeContainer tree;
        private AttributeContainer[] attributes;

        public RootManager(ContainerManagementState containerManagementState, EntityData ed, EntityId rootId) {
            this.rootId = rootId;
            this.tree = containerManagementState.new TreeContainer(ed, rootId);
            this.attributes = new AttributeContainer[]{containerManagementState.new AttributeContainer(ed, ShapeInfo.class, rootId), containerManagementState.new AttributeContainer(ed, ObjectName.class, rootId)};
        }

        public void start() {
            this.tree.start();
            for (AttributeContainer container : this.attributes) {
                container.start();
            }
        }

        public void update() {
            this.tree.update();
            for (AttributeContainer container : this.attributes) {
                container.update();
            }
        }

        public void stop() {
            this.tree.stop();
            for (AttributeContainer container : this.attributes) {
                container.stop();
            }
        }
    }

    private class TreeContainer
    extends EntityContainer<TreeNode> {
        private EntityId rootId;
        private TreeNode rootNode;

        public TreeContainer(EntityData ed, EntityId rootId) {
            super(ed, new Class[]{ContainedIn.class});
            this.rootId = rootId;
            this.rootNode = ContainerManagementState.this.getTreeNode(rootId, true);
            this.setFilter(Filters.fieldEquals(ContainedIn.class, (String)"root", (Object)rootId));
        }

        public TreeNode[] getArray() {
            return (TreeNode[])super.getArray();
        }

        protected void updateHierarchy(TreeNode object, EntityId parentId) {
            TreeNode newParent;
            if (Objects.equals(parentId, object.getParentId())) {
                log.info("moved in the same container");
                return;
            }
            TreeNode treeNode = newParent = parentId == null ? null : ContainerManagementState.this.getTreeNode(parentId, true);
            if (Objects.equals(parentId, object.getEntityId())) {
                log.error("Cycle detected:" + object + " into:" + parentId);
                return;
            }
            TreeNode oldParent = object.getParent();
            if (oldParent != null) {
                log.info("removing from:" + oldParent.getEntityId());
                oldParent.removeChild(object);
            }
            if (newParent != null) {
                log.info("adding to:" + newParent.getEntityId());
                newParent.addChild(object);
            }
        }

        protected TreeNode addObject(Entity e) {
            if (log.isTraceEnabled()) {
                log.trace("add node:" + e);
            }
            ContainedIn in = (ContainedIn)e.get(ContainedIn.class);
            TreeNode object = ContainerManagementState.this.getTreeNode(e.getId(), true);
            object.acquire();
            if (object.getManager() != null) {
                log.info("entity:" + e.getId() + " already has manager:" + object.getManager());
                if (!object.getManager().isType(in.getType())) {
                    log.warn("existing manager:" + object.getManager() + " does not match type:" + in.getType());
                }
            } else {
                switch (in.getType()) {
                    default: {
                        object.setManager(new ItemManager(e.getId()));
                        break;
                    }
                    case 2: {
                        object.setManager(new SectionManager(ContainerManagementState.this, e.getId()));
                        break;
                    }
                    case 1: {
                        object.setManager(new ContainerManager(e.getId()));
                    }
                }
            }
            this.updateObject(object, e);
            return object;
        }

        protected void updateObject(TreeNode object, Entity e) {
            if (log.isTraceEnabled()) {
                log.trace("update node:" + object);
            }
            log.info("update node:" + object);
            ContainedIn containedIn = (ContainedIn)e.get(ContainedIn.class);
            this.updateHierarchy(object, containedIn.getContainer());
            object.update((EntityComponent)containedIn);
        }

        protected void removeObject(TreeNode object, Entity e) {
            if (log.isTraceEnabled()) {
                log.trace("remove node:" + object);
            }
            log.info("remove node:" + object + "  containedIn:" + e.get(ContainedIn.class));
            object.release();
        }
    }

    private class TreeNode {
        private EntityId entityId;
        private TreeNode parent;
        private List<TreeNode> children = new ArrayList<TreeNode>();
        private AbstractManager manager;
        private List<Runnable> pending = new ArrayList<Runnable>();
        private int useCount = 0;

        public TreeNode(ContainerManagementState containerManagementState, EntityId entityId) {
            this.entityId = entityId;
        }

        public EntityId getEntityId() {
            return this.entityId;
        }

        public EntityId getParentId() {
            return this.parent == null ? null : this.parent.entityId;
        }

        public TreeNode getParent() {
            return this.parent;
        }

        public AbstractManager getManager() {
            return this.manager;
        }

        public void setManager(AbstractManager manager) {
            if (this.manager != null) {
                throw new IllegalStateException("Node already has a manager:" + this.manager);
            }
            this.manager = manager;
            for (Runnable r : this.pending) {
                if (log.isTraceEnabled()) {
                    log.trace("applying pending:" + r + " to:" + this.entityId);
                }
                r.run();
            }
            this.pending.clear();
            for (TreeNode child : this.children) {
                if (child.manager == null) continue;
                manager.addChild(child.manager);
            }
            if (this.parent != null && this.parent.manager != null) {
                this.parent.manager.addChild(manager);
            }
        }

        public void addChild(TreeNode child) {
            log.info("addChild(" + child.entityId + ") to:" + this.entityId);
            if (child.parent != null) {
                throw new IllegalStateException("Child is still in another node:" + child.parent);
            }
            child.parent = this;
            this.children.add(child);
            if (this.manager != null && child.manager != null) {
                this.manager.addChild(child.manager);
            }
        }

        public void removeChild(TreeNode child) {
            log.info("removeChild(" + child.entityId + ") from:" + this.entityId);
            if (child.parent == null) {
                throw new IllegalStateException("Child has no parent, child:" + child);
            }
            if (child.parent != this) {
                throw new IllegalStateException("Child belongs to different parent:" + child.parent + " this:" + this);
            }
            child.parent = null;
            this.children.remove(child);
            if (this.manager != null && child.manager != null) {
                this.manager.removeChild(child.manager);
            }
        }

        public void update(EntityComponent component) {
            if (this.manager != null) {
                this.manager.set(component);
            } else {
                this.pending.add(() -> this.manager.set(component));
            }
        }

        public void acquire() {
            ++this.useCount;
        }

        public boolean release() {
            --this.useCount;
            if (this.useCount < 0) {
                throw new IllegalStateException("More releases than acquires for:" + this.entityId);
            }
            if (this.useCount == 0) {
                if (this.parent != null) {
                    this.parent.removeChild(this);
                }
                if (this.manager != null) {
                    this.manager.release();
                }
                return true;
            }
            return false;
        }

        public String toString() {
            if (this.manager == null) {
                return "null root";
            }
            return this.manager.toString();
        }
    }

    private class AttributeContainer
    extends EntityContainer<TreeNode> {
        private EntityId rootId;
        private TreeNode rootNode;
        private Class<? extends EntityComponent> type;

        public AttributeContainer(EntityData ed, Class<? extends EntityComponent> type, EntityId rootId) {
            super(ed, new Class[]{ContainedIn.class, type});
            this.rootId = rootId;
            this.rootNode = ContainerManagementState.this.getTreeNode(rootId, true);
            this.type = type;
            this.setFilter(Filters.fieldEquals(ContainedIn.class, (String)"root", (Object)rootId));
        }

        public TreeNode[] getArray() {
            return (TreeNode[])super.getArray();
        }

        protected TreeNode addObject(Entity e) {
            if (log.isTraceEnabled()) {
                log.trace("add attribute[" + this.type.getSimpleName() + "]:" + e);
            }
            TreeNode object = ContainerManagementState.this.getTreeNode(e.getId(), true);
            this.updateObject(object, e);
            return object;
        }

        protected void updateObject(TreeNode object, Entity e) {
            if (log.isTraceEnabled()) {
                log.trace("update attribute[" + this.type.getSimpleName() + "]:" + e);
            }
            object.update(e.get(this.type));
        }

        protected void removeObject(TreeNode object, Entity e) {
            if (log.isTraceEnabled()) {
                log.trace("remove attribute[" + this.type.getSimpleName() + "]:" + e);
            }
        }
    }

    private class ContainerManager
    extends ItemManager {
        private ItemContainer container;

        public ContainerManager(EntityId entityId) {
            super(entityId);
            this.container = new ItemContainer(entityId, this.getItem());
            this.container.setContainerPosition(new Vec3d(5.0, 5.0, 0.0));
            ContainerManagementState.this.itemViews.addItemContainer(this.container);
        }

        public ItemContainer getContainer() {
            return this.container;
        }

        @Override
        public boolean isType(int type) {
            return type == 1;
        }

        @Override
        public void addChild(AbstractManager child) {
            if (child instanceof ItemManager) {
                this.container.add(((ItemManager)child).getItem());
            } else if (child instanceof SectionManager) {
                this.container.addSection(((SectionManager)child).getSection());
            }
        }

        @Override
        public void removeChild(AbstractManager child) {
            if (child instanceof ItemManager) {
                this.container.remove(((ItemManager)child).getItem());
            } else if (child instanceof SectionManager) {
                // empty if block
            }
        }

        @Override
        public void set(EntityComponent component) {
            super.set(component);
        }

        @Override
        protected void setShape(ShapeInfo shape) {
            super.setShape(shape);
            ContainerManagementState.this.containerSizeResolver.accept(this.getEntityId(), size -> ContainerManagementState.this.getApplication().enqueue(() -> this.container.setContainerSize((InventorySize2d)size)));
        }

        @Override
        public String toString() {
            String shapeString;
            String string = shapeString = this.getShape() == null ? null : this.getShape().toString(ContainerManagementState.this.ed);
            if (this.getName() == null) {
                return this.getClass().getSimpleName() + "[entityId:" + this.getEntityId() + ", container:" + this.container + "]";
            }
            return this.getClass().getSimpleName() + "[name:" + this.getName() + ", entityId:" + this.getEntityId() + ", container:" + this.container + "]";
        }
    }

    private class ItemManager
    extends AbstractManager {
        private Item item;
        private ShapeInfo shape;

        public ItemManager(EntityId entityId) {
            super(entityId);
            this.item = new Item(entityId, null);
        }

        public Item getItem() {
            return this.item;
        }

        @Override
        public boolean isType(int type) {
            return type == 0;
        }

        @Override
        public void set(EntityComponent component) {
            super.set(component);
            if (component instanceof ShapeInfo) {
                this.setShape((ShapeInfo)component);
            } else if (component instanceof ContainedIn) {
                this.setContainedIn((ContainedIn)component);
            }
        }

        protected ShapeInfo getShape() {
            return this.shape;
        }

        protected void setShape(ShapeInfo shape) {
            if (Objects.equals(this.shape, shape)) {
                return;
            }
            this.shape = shape;
            ContainerManagementState.this.shapeResolver.accept(shape, this.item::setModel);
            ContainerManagementState.this.itemSizeResolver.accept(this.getEntityId(), size -> ContainerManagementState.this.getApplication().enqueue(() -> this.item.setItemSize((InventorySize2d)size)));
        }

        protected void setContainedIn(ContainedIn containedIn) {
            this.item.setSlot(new Vec3i(containedIn.getX(), containedIn.getY(), 0));
            this.item.setMaxCount(Math.max(1, containedIn.getMaxStackSize()));
        }

        @Override
        public String toString() {
            String shapeString;
            String string = shapeString = this.shape == null ? null : this.shape.toString(ContainerManagementState.this.ed);
            if (this.getName() == null) {
                return this.getClass().getSimpleName() + "[entityId:" + this.getEntityId() + ", item:" + this.item + "]";
            }
            return this.getClass().getSimpleName() + "[name:" + this.getName() + ", entityId:" + this.getEntityId() + ", item:" + this.item + "]";
        }
    }

    private class SectionManager
    extends AbstractManager {
        private ContainerSection section;

        public SectionManager(ContainerManagementState containerManagementState, EntityId entityId) {
            super(entityId);
            this.section = new ContainerSection(entityId);
        }

        public ContainerSection getSection() {
            return this.section;
        }

        @Override
        public boolean isType(int type) {
            return type == 2;
        }

        @Override
        protected void setName(String name) {
            super.setName(name);
            this.section.setName(name);
        }

        @Override
        public void addChild(AbstractManager child) {
            if (child instanceof ItemManager) {
                this.section.add(((ItemManager)child).getItem());
            }
        }

        @Override
        public void removeChild(AbstractManager child) {
            if (child instanceof ItemManager) {
                this.section.remove(((ItemManager)child).getItem());
            }
        }

        @Override
        public String toString() {
            return this.getClass().getSimpleName() + "[name:" + this.getName() + ", entityId:" + this.getEntityId() + "]";
        }
    }

    private abstract class AbstractManager {
        private final EntityId entityId;
        private String name;

        protected AbstractManager(EntityId entityId) {
            this.entityId = entityId;
        }

        public EntityId getEntityId() {
            return this.entityId;
        }

        public abstract boolean isType(int var1);

        public String getName() {
            return this.name;
        }

        protected void setName(String name) {
            this.name = name;
        }

        public void set(EntityComponent component) {
            if (component instanceof ObjectName) {
                int nameId = ((ObjectName)component).getNameId();
                ContainerManagementState.this.retriever.getString(nameId, this::setName);
            }
        }

        public void addChild(AbstractManager child) {
        }

        public void removeChild(AbstractManager child) {
        }

        public void release() {
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[entityId:" + this.entityId + "]";
        }
    }
}

