/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.ui.item;

import com.jme3.bounding.BoundingBox;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector3f;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.simsilica.es.EntityId;
import com.simsilica.lemur.Action;
import com.simsilica.lemur.ActionButton;
import com.simsilica.lemur.Axis;
import com.simsilica.lemur.Button;
import com.simsilica.lemur.Container;
import com.simsilica.lemur.FillMode;
import com.simsilica.lemur.component.BorderLayout;
import com.simsilica.lemur.component.SpringGridLayout;
import com.simsilica.lemur.core.GuiLayout;
import com.simsilica.lemur.core.VersionedReference;
import com.simsilica.lemur.event.CursorEventControl;
import com.simsilica.lemur.event.CursorListener;
import com.simsilica.lemur.event.DragHandler;
import com.simsilica.lemur.style.ElementId;
import com.simsilica.mathd.Vec3d;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import mythruna.client.ui.item.ContainerSection;
import mythruna.client.ui.item.ContainerSectionView;
import mythruna.client.ui.item.ItemContainer;
import mythruna.client.ui.item.ItemListener;
import mythruna.item.InventorySize2d;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ItemContainerView
extends Node {
    static Logger log = LoggerFactory.getLogger(ItemContainerView.class);
    private Node worldRoot;
    private ItemContainer container;
    private ItemListener itemListener;
    private VersionedReference<List<ContainerSection>> sectionsRef;
    private VersionedReference<ContainerSection> currentSectionRef;
    private ContainerSectionView sectionView;
    private Map<EntityId, ContainerSectionView> viewIndex = new HashMap<EntityId, ContainerSectionView>();
    private Map<EntityId, SectionButton> buttonIndex = new HashMap<EntityId, SectionButton>();
    private Spatial model;
    private VersionedReference<InventorySize2d> containerSizeRef;
    private VersionedReference<Vec3d> containerPosRef;
    private VersionedReference<Spatial> modelRef;
    private VersionedReference<InventorySize2d> itemSizeRef;
    private Container topMenu;
    private Container sectionButtons;
    private Container windowButtons;
    private float topMenuScale = 0.04f;
    private double lastMenuWidth = 0.0;

    public ItemContainerView(Node worldRoot, ItemContainer container, ItemListener itemListener) {
        this.worldRoot = worldRoot;
        this.container = container;
        this.itemListener = itemListener;
        this.topMenu = new Container((GuiLayout)new BorderLayout());
        this.topMenu.setLocalScale(this.topMenuScale);
        this.sectionButtons = (Container)this.topMenu.addChild((Node)new Container(), new Object[]{BorderLayout.Position.West});
        this.windowButtons = (Container)this.topMenu.addChild((Node)this.createRow(), new Object[]{BorderLayout.Position.East});
        this.windowButtons.addChild((Node)new Button("?", new ElementId("section.button")), new Object[0]);
        this.attachChild((Spatial)this.topMenu);
        this.sectionsRef = container.getSections().createReference();
        this.currentSectionRef = container.createCurrentSectionRef();
        this.updateSections((List)this.sectionsRef.get());
        this.resetCurrentSection((ContainerSection)((Object)this.currentSectionRef.get()));
        this.containerSizeRef = container.createContainerSizeRef();
        this.containerPosRef = container.createContainerPositionRef();
        this.modelRef = container.getContainerItem().createModelRef();
        this.itemSizeRef = container.getContainerItem().createItemSizeRef();
        this.resetContainerSize((InventorySize2d)this.containerSizeRef.get());
        this.resetModel((Spatial)this.modelRef.get());
        this.resetPosition((Vec3d)this.containerPosRef.get());
        CursorEventControl.addListenersToSpatial((Spatial)this, (CursorListener[])new CursorListener[]{new DragHandler()});
    }

    public void updateLogicalState(float tpf) {
        super.updateLogicalState(tpf);
        if (this.sectionsRef.update()) {
            this.updateSections((List)this.sectionsRef.get());
        }
        if (this.currentSectionRef.update()) {
            this.resetCurrentSection((ContainerSection)((Object)this.currentSectionRef.get()));
        }
        if (this.containerSizeRef.update()) {
            this.resetContainerSize((InventorySize2d)this.containerSizeRef.get());
        }
        if (this.modelRef.update()) {
            this.resetModel((Spatial)this.modelRef.get());
        }
        if (this.itemSizeRef.update()) {
            this.resetModelPosition();
        }
        if (this.containerPosRef.update()) {
            this.resetPosition((Vec3d)this.containerPosRef.get());
        }
    }

    protected void updateSections(List<ContainerSection> sections) {
        HashSet<ContainerSectionView> oldViews = new HashSet<ContainerSectionView>(this.viewIndex.values());
        HashMap<EntityId, ContainerSectionView> newViews = new HashMap<EntityId, ContainerSectionView>();
        for (ContainerSection section : sections) {
            ContainerSectionView view = this.viewIndex.get(section.getEntityId());
            if (view == null) {
                view = new ContainerSectionView(this.worldRoot, section, this.itemListener);
                this.attachChild((Spatial)view);
            }
            newViews.put(section.getEntityId(), view);
            SectionButton button = this.buttonIndex.get(section.getEntityId());
            if (button != null) continue;
            button = new SectionButton(this, section);
            this.buttonIndex.put(section.getEntityId(), button);
        }
        for (ContainerSectionView old : oldViews) {
            old.removeFromParent();
            this.buttonIndex.remove(old.getSection().getEntityId());
        }
        this.viewIndex = newViews;
        this.updateSectionButtonLayout(true);
    }

    protected Container createRow() {
        return new Container((GuiLayout)new SpringGridLayout(Axis.X, Axis.Y, FillMode.None, FillMode.None));
    }

    protected void updateSectionState() {
        for (ContainerSection section : (List)this.sectionsRef.get()) {
            ContainerSectionView view = this.viewIndex.get(section.getEntityId());
            if (view == null) {
                log.warn("Missing view for:" + section);
                continue;
            }
            SectionButton b = this.buttonIndex.get(section.getEntityId());
            if (b == null) {
                log.warn("Missing button for:" + section);
                continue;
            }
            b.getAction().setSelected(section == this.currentSectionRef.get());
            if (view == this.sectionView) {
                view.setEnabled(true);
                continue;
            }
            view.setEnabled(false);
        }
    }

    protected void updateSectionButtonLayout(boolean force) {
        float maxWidth;
        if (this.containerSizeRef != null && this.containerSizeRef.get() != null) {
            InventorySize2d size = (InventorySize2d)this.containerSizeRef.get();
            maxWidth = (float)size.getXSlots() / this.topMenuScale * 0.85f;
        } else {
            maxWidth = 100.0f;
        }
        if (!force && (double)maxWidth == this.lastMenuWidth) {
            return;
        }
        this.lastMenuWidth = maxWidth;
        List sections = (List)this.sectionsRef.get();
        this.sectionButtons.clearChildren();
        if (sections.size() <= 1) {
            return;
        }
        Container row = (Container)this.sectionButtons.addChild((Node)this.createRow(), new Object[0]);
        for (ContainerSection section : sections) {
            ContainerSectionView view = this.viewIndex.get(section.getEntityId());
            if (view == null) {
                log.warn("Missing view for:" + section);
                continue;
            }
            SectionButton b = this.buttonIndex.get(section.getEntityId());
            if (b == null) {
                log.warn("Missing button for:" + section);
                continue;
            }
            float rowWidth = row.getPreferredSize().x;
            float buttonWidth = b.getPreferredSize().x;
            if (rowWidth + buttonWidth > maxWidth) {
                row = (Container)this.sectionButtons.addChild((Node)this.createRow(), new Object[0]);
                row.addChild((Node)b, new Object[0]);
                continue;
            }
            row.addChild((Node)b, new Object[0]);
        }
        this.updateSectionState();
    }

    protected void resetCurrentSection(ContainerSection section) {
        ContainerSectionView newView = this.viewIndex.get(section.getEntityId());
        log.info("resetCurrentSection(" + section + ")");
        if (newView == this.sectionView) {
            return;
        }
        if (this.sectionView != null) {
            log.info("detaching:" + this.sectionView);
        }
        this.sectionView = newView;
        if (this.sectionView != null) {
            log.info("attaching:" + this.sectionView);
        }
        this.resetModelPosition();
        this.updateSectionState();
    }

    protected void resetModel(Spatial model) {
        this.model = model == null ? null : model.clone();
        this.resetModelPosition();
    }

    protected void resetModelPosition() {
        log.info("resetModelPosition() model:" + this.model);
        if (this.model == null) {
            return;
        }
        this.model.setLocalRotation(((InventorySize2d)this.containerSizeRef.get()).getRotation().toQuaternion());
        InventorySize2d itemSize = (InventorySize2d)this.itemSizeRef.get();
        InventorySize2d containerSize = (InventorySize2d)this.containerSizeRef.get();
        if (itemSize == null || containerSize == null) {
            return;
        }
        this.model.removeFromParent();
        this.model.setLocalScale(1.0f);
        this.model.setLocalTranslation(0.0f, 0.0f, 0.0f);
        BoundingBox bb = (BoundingBox)this.model.getWorldBound();
        Vec3d gridSize = this.sectionView.getGridSize();
        Vec3d iSize = containerSize.getRotation().mult(itemSize.getSize());
        Vec3d cSize = containerSize.getRotation().mult(containerSize.getSize());
        Vec3d bbSize = new Vec3d(bb.getExtent(null)).multLocal(2.0);
        double xDesired = iSize.x * gridSize.x / cSize.x;
        double yDesired = iSize.y * gridSize.y / cSize.y;
        double xScale = (xDesired += 0.4) / bbSize.x;
        double yScale = (yDesired += 0.4) / bbSize.y;
        double scale = Math.max(xScale, yScale);
        this.model.setLocalScale((float)scale);
        double xOffset = gridSize.x * 0.5 - (double)bb.getCenter().x * scale;
        double yOffset = -(gridSize.y * 0.5) - (double)bb.getCenter().y * scale;
        double zOffset = -((double)(bb.getCenter().z * 2.0f) * scale);
        double zSize = (double)(bb.getZExtent() * 2.0f) * scale;
        this.model.setLocalTranslation((float)xOffset, (float)yOffset, (float)zOffset);
        this.model.move(0.0f, 0.0f, -0.02f);
        this.attachChild(this.model);
        this.layoutSections(zSize);
        this.updateSectionButtonLayout(false);
        this.topMenu.setPreferredSize(null);
        Vector3f pref = this.topMenu.getPreferredSize();
        pref.x = (float)(gridSize.x / (double)this.topMenuScale);
        this.topMenu.setPreferredSize(pref);
        float borderSize = 0.2f;
        this.topMenu.setLocalTranslation(0.0f, pref.y * this.topMenuScale + borderSize, 0.0f);
    }

    protected void layoutSections(double zSize) {
        List sections = (List)this.sectionsRef.get();
        if (sections.size() <= 1) {
            if (this.sectionView != null) {
                this.sectionView.setLocalTranslation(0.0f, 0.0f, 0.0f);
                this.sectionView.setEnabled(true);
            }
            return;
        }
        int count = sections.size();
        double spacing = zSize / (double)(count + 2);
        double zOffset = -spacing;
        for (ContainerSection section : sections) {
            ContainerSectionView view = this.viewIndex.get(section.getEntityId());
            if (view == this.sectionView) {
                view.setLocalTranslation(0.0f, 0.0f, 0.0f);
                view.setEnabled(true);
            } else {
                view.setLocalTranslation(0.0f, 0.0f, (float)zOffset);
                view.setEnabled(false);
            }
            zOffset -= spacing;
        }
    }

    protected void resetContainerSize(InventorySize2d size) {
        for (ContainerSectionView view : this.viewIndex.values()) {
            view.resetContainerSize(size);
        }
        this.resetModelPosition();
    }

    protected void resetPosition(Vec3d pos) {
        this.setLocalTranslation(pos.toVector3f());
    }

    protected class SectionButton
    extends ActionButton {
        private ColorRGBA textColor = new ColorRGBA(0.9f, 0.3f, 0.8f, 0.7f);
        private ColorRGBA selectedColor = new ColorRGBA(0.3f, 0.3f, 1.0f, 0.9f);

        public SectionButton(ItemContainerView this$0, ContainerSection section) {
            super((Action)this$0.new SectionAction(section), new ElementId("section.button"));
            this.textColor = this.getColor();
            this.updateTextColor();
        }

        protected void updateTextColor() {
            if (this.textColor == null) {
                return;
            }
            if (this.getAction().isSelected()) {
                this.setColor(this.selectedColor);
            } else {
                this.setColor(this.textColor);
            }
        }

        protected void updateText() {
            super.updateText();
            this.updateTextColor();
        }
    }

    protected class SectionAction
    extends Action {
        private ContainerSection section;
        private VersionedReference<String> nameRef;

        public SectionAction(ContainerSection section) {
            this.section = section;
            this.nameRef = section.createNameRef();
        }

        public long getVersion() {
            return super.getVersion() + this.nameRef.getObjectVersion();
        }

        public String getName() {
            return this.section.getName();
        }

        public void execute(Button source) {
            log.info("Switch to:" + this.section);
            ItemContainerView.this.container.setCurrentSection(this.section);
        }
    }
}

