/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.view;

import com.jme3.material.RenderState;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector3f;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.VertexBuffer;
import com.simsilica.es.EntityId;
import com.simsilica.ext.mphys.debug.BodyDebugState;
import com.simsilica.ext.mphys.debug.DebugShapeFactory;
import com.simsilica.lemur.GuiGlobals;
import com.simsilica.mathd.Quatd;
import com.simsilica.mathd.Vec3d;
import com.simsilica.mblock.phys.MBlockShape;
import com.simsilica.mphys.Frustum;
import com.simsilica.mphys.RigidBody;
import java.util.HashMap;
import java.util.Map;
import mythruna.sim.PlayerDriver;
import mythruna.sim.ai.AgentDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ViewFrustumDebugShapeFactory
implements DebugShapeFactory<MBlockShape> {
    static Logger log = LoggerFactory.getLogger(ViewFrustumDebugShapeFactory.class);
    private Map<EntityId, FrustumView> views = new HashMap<EntityId, FrustumView>();

    public void initialize(BodyDebugState<MBlockShape> parent) {
    }

    public void terminate(BodyDebugState<MBlockShape> parent) {
    }

    public void addDebugShape(RigidBody<EntityId, MBlockShape> body, Node view, ColorRGBA temperature) {
        if (body.getControlDriver() instanceof PlayerDriver) {
            log.info("******* add PLAYER:" + body);
            PlayerDriver playerDriver = (PlayerDriver)body.getControlDriver();
        } else if (body.getControlDriver() instanceof AgentDriver) {
            // empty if block
        }
    }

    public void updateDebugShape(RigidBody<EntityId, MBlockShape> body, Node view, ColorRGBA temperature) {
        FrustumView frustumView = this.views.get(body.id);
        if (frustumView != null) {
            frustumView.update();
        }
    }

    public void releaseDebugShape(RigidBody<EntityId, MBlockShape> body, Node view) {
        FrustumView frustumView = this.views.remove(body.id);
    }

    protected void addFrustumView(RigidBody<EntityId, MBlockShape> body, Node view, Frustum frustum) {
        FrustumView frustumView = new FrustumView(this, body, view, frustum);
        this.views.put((EntityId)body.id, frustumView);
    }

    private class FrustumView {
        private RigidBody<EntityId, MBlockShape> body;
        private Node view;
        private Frustum frustum;
        private Geometry geom;
        private Mesh mesh;

        public FrustumView(ViewFrustumDebugShapeFactory viewFrustumDebugShapeFactory, RigidBody<EntityId, MBlockShape> body, Node view, Frustum frustum) {
            this.body = body;
            this.view = view;
            this.frustum = frustum;
            Vec3d local = body.worldToLocal(frustum.getPosition(), null);
            Vec3d dir = body.orientation.inverse().mult(frustum.getUp());
            double yFov = frustum.getVerticalFov() * 0.5;
            double xFov = frustum.getHorizontalFov() * 0.5;
            Vec3d offset = new Vec3d();
            offset.z = frustum.getFar();
            offset.x = Math.tan(xFov) * offset.z;
            offset.y = Math.tan(yFov) * offset.z;
            Vector3f ul = offset.toVector3f();
            Vector3f ur = new Vector3f(-ul.x, ul.y, ul.z);
            Vector3f ll = new Vector3f(ul.x, -ul.y, ul.z);
            Vector3f lr = new Vector3f(-ul.x, -ul.y, ul.z);
            this.mesh = new Mesh();
            this.mesh.setMode(Mesh.Mode.Lines);
            this.mesh.setBuffer(VertexBuffer.Type.Position, 3, new float[]{0.0f, 0.0f, 0.0f, ul.x, ul.y, ul.z, 0.0f, 0.0f, 0.0f, ur.x, ur.y, ur.z, 0.0f, 0.0f, 0.0f, ll.x, ll.y, ll.z, 0.0f, 0.0f, 0.0f, lr.x, lr.y, lr.z, ul.x, ul.y, ul.z, ur.x, ur.y, ur.z, ur.x, ur.y, ur.z, lr.x, lr.y, lr.z, lr.x, lr.y, lr.z, ll.x, ll.y, ll.z, ll.x, ll.y, ll.z, ul.x, ul.y, ul.z});
            this.mesh.updateBound();
            this.geom = new Geometry(body.id + ".frustum", this.mesh);
            this.geom.setMaterial(GuiGlobals.getInstance().createMaterial(ColorRGBA.Red, false).getMaterial());
            this.geom.setLocalTranslation(local.toVector3f());
            this.geom.setLocalRotation(frustum.getOrientation().toQuaternion());
            this.geom.setQueueBucket(RenderQueue.Bucket.Transparent);
            this.geom.getMaterial().getAdditionalRenderState().setBlendMode(RenderState.BlendMode.Alpha);
            view.attachChild((Spatial)this.geom);
        }

        public void update() {
            Vec3d local = this.body.worldToLocal(this.frustum.getPosition(), null);
            Quatd rot = this.body.orientation.inverse().mult(this.frustum.getOrientation());
            this.geom.setLocalTranslation(local.toVector3f());
            this.geom.setLocalRotation(rot.toQuaternion());
        }
    }
}

