/*
 * Decompiled with CFR 0.152.
 */
package mythruna.world;

import com.simsilica.mathd.Vec3i;
import com.simsilica.mworld.tile.TerrainImage;
import com.simsilica.mworld.tile.TerrainImageId;
import com.simsilica.mworld.tile.TerrainImageType;
import com.simsilica.mworld.tile.Tile;
import com.simsilica.mworld.tile.TileFunction;
import mythruna.world.BioInfo;
import mythruna.world.TerrainTypes;
import mythruna.world.WorldFractal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TerrainTypeGenerator
implements TileFunction {
    static Logger log = LoggerFactory.getLogger(TerrainTypeGenerator.class);
    private int seaLevel = 128;
    private int treeLine = 618;
    private WorldFractal fractal;

    public TerrainTypeGenerator(WorldFractal fractal) {
        this.fractal = fractal;
    }

    public void accept(Tile tile) {
        TerrainImage terrain = (TerrainImage)tile.get((Object)TerrainImageType.Terrain, TerrainImage.class);
        TerrainImage fluid = (TerrainImage)tile.get((Object)TerrainImageType.Fluid, TerrainImage.class);
        if (terrain.getVersion().getLoadVersion() < 0L) {
            this.generateTypes(terrain);
        }
    }

    private double clamp(double val, double min, double max) {
        if (val <= min) {
            return min;
        }
        if (val >= max) {
            return max;
        }
        return val;
    }

    protected void generateTypes(TerrainImage target) {
        TerrainImageId id = target.getId();
        Vec3i world = id.getTileId().getWorld(null);
        double xCorner = world.x;
        double zCorner = world.z;
        int scale = 1024 / id.getResolution().getSamples();
        int size = target.getSize();
        boolean pos = false;
        BioInfo info = new BioInfo();
        for (int z = 0; z < size; ++z) {
            for (int x = 0; x < size; ++x) {
                double iceFactor;
                double xp = xCorner + (double)(x * scale);
                double zp = zCorner + (double)(z * scale);
                boolean debug = false;
                if (debug) {
                    log.info("Debugging:" + xp + ", " + zp);
                }
                short elevation = target.getElevation(x, z);
                double yp = elevation;
                int baseType = 0;
                int foliage = 0;
                int wetness = 0;
                int frozen = 0;
                this.fractal.getBioInfo(xp, yp, zp, info);
                if (debug) {
                    log.info("bio:" + info);
                }
                if (info.temperature <= 0.2857) {
                    if (debug) {
                        log.info("frozen");
                    }
                    frozen = 1;
                }
                baseType = elevation <= this.seaLevel ? 0 : (elevation >= this.treeLine ? 5 : (info.vegetationLevel <= 0.1 && info.temperature > 0.5 ? 0 : (frozen > 0 && info.precipitation > 0.5 ? (info.precipitation + (iceFactor = (0.2857 - info.temperature) / 0.2857) * 0.5 > 0.8 ? 7 : 1) : 1)));
                if (debug) {
                    log.info("base type:" + baseType);
                }
                foliage = (int)Math.round(info.vegetationLevel * 3.0) & 3;
                wetness = (int)Math.round(info.precipitation * 3.0) & 3;
                if (debug) {
                    log.info("foliage:" + foliage + "  wetness:" + wetness);
                }
                if (yp > (double)this.seaLevel && baseType == 0 && wetness > 1 && foliage == 0) {
                    baseType = 1;
                    --wetness;
                    if (debug) {
                        log.info("sand-to-dirt -> foliage:" + foliage + "  wetness:" + wetness);
                    }
                }
                if (yp > (double)this.seaLevel && wetness > 0 && foliage == 0 && baseType == 1) {
                    foliage = (int)Math.round(info.soilQuality * 3.0) & 3;
                    if (frozen == 0) {
                        --wetness;
                    }
                    if (debug) {
                        log.info("foliage upgrade -> foliage:" + foliage + "  wetness:" + wetness);
                    }
                }
                if (baseType != 7 && baseType < 2) {
                    int n = scale > 1 || z == 0 ? (int)this.fractal.getElevation(xp, zp - 1.0) : target.getElevation(x, z - 1);
                    int s = scale > 1 || z == size - 1 ? (int)this.fractal.getElevation(xp, zp + 1.0) : (int)target.getElevation(x, z + 1);
                    int w = scale > 1 || x == 0 ? (int)this.fractal.getElevation(xp - 1.0, zp) : target.getElevation(x - 1, z);
                    int e = scale > 1 || x == size - 1 ? (int)this.fractal.getElevation(xp + 1.0, zp) : (int)target.getElevation(x + 1, z);
                    int maxDrop = 0;
                    boolean threshold = true;
                    maxDrop = Math.max(maxDrop, elevation - n);
                    maxDrop = Math.max(maxDrop, elevation - s);
                    maxDrop = Math.max(maxDrop, elevation - e);
                    if ((maxDrop = Math.max(maxDrop, elevation - w)) > 2) {
                        baseType = 5;
                    } else if (maxDrop > 1) {
                        baseType = baseType == 0 ? 5 : 1;
                    }
                }
                int type = baseType & 7 | (foliage & 3) << 3 | (wetness & 3) << 5 | frozen << 7;
                target.setType(x, z, (byte)type);
                if (wetness == TerrainTypes.getWetnessLevel(type)) continue;
                throw new RuntimeException("See... that's not right.");
            }
        }
        target.getVersion().markChanged();
    }
}

