/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.anim.interpolator;

import com.jme3.anim.interpolator.AnimInterpolator;
import com.jme3.anim.interpolator.FrameInterpolator;
import com.jme3.math.EaseFunction;
import com.jme3.math.Easing;
import com.jme3.math.FastMath;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;

public class AnimInterpolators {
    public static final CatmullRomInterpolator CatmullRom = new CatmullRomInterpolator();
    public static final TimeInterpolator easeInQuad = new TimeInterpolator(Easing.inQuad);
    public static final TimeInterpolator easeInCubic = new TimeInterpolator(Easing.inCubic);
    public static final TimeInterpolator easeInQuart = new TimeInterpolator(Easing.inQuart);
    public static final TimeInterpolator easeInQuint = new TimeInterpolator(Easing.inQuint);
    public static final TimeInterpolator easeInBounce = new TimeInterpolator(Easing.inBounce);
    public static final TimeInterpolator easeInElastic = new TimeInterpolator(Easing.inElastic);
    public static final TimeInterpolator easeOutQuad = new TimeInterpolator(Easing.outQuad);
    public static final TimeInterpolator easeOutCubic = new TimeInterpolator(Easing.outCubic);
    public static final TimeInterpolator easeOutQuart = new TimeInterpolator(Easing.outQuart);
    public static final TimeInterpolator easeOutQuint = new TimeInterpolator(Easing.outQuint);
    public static final TimeInterpolator easeOutBounce = new TimeInterpolator(Easing.outBounce);
    public static final TimeInterpolator easeOutElastic = new TimeInterpolator(Easing.outElastic);
    public static final TimeInterpolator easeInOutQuad = new TimeInterpolator(Easing.inOutQuad);
    public static final TimeInterpolator easeInOutCubic = new TimeInterpolator(Easing.inOutCubic);
    public static final TimeInterpolator easeInOutQuart = new TimeInterpolator(Easing.inOutQuart);
    public static final TimeInterpolator easeInOutQuint = new TimeInterpolator(Easing.inOutQuint);
    public static final TimeInterpolator easeInOutBounce = new TimeInterpolator(Easing.inOutBounce);
    public static final TimeInterpolator easeInOutElastic = new TimeInterpolator(Easing.inOutElastic);
    public static final TimeInterpolator smoothStep = new TimeInterpolator(Easing.smoothStep);
    public static final TimeInterpolator smootherStep = new TimeInterpolator(Easing.smootherStep);
    public static final TimeInterpolator constant = new TimeInterpolator(Easing.constant);

    public static final AnimInterpolator<Quaternion> nlerp() {
        return new AnimInterpolator<Quaternion>(){
            private Quaternion next = new Quaternion();

            @Override
            public Quaternion interpolate(float t, int currentIndex, FrameInterpolator.TrackDataReader<Quaternion> data, FrameInterpolator.TrackTimeReader times, Quaternion store) {
                data.getEntryClamp(currentIndex, store);
                data.getEntryClamp(currentIndex + 1, this.next);
                store.nlerp(this.next, t);
                return store;
            }
        };
    }

    public static final AnimInterpolator<Vector3f> linearVec3f() {
        return new AnimInterpolator<Vector3f>(){
            private Vector3f next = new Vector3f();

            @Override
            public Vector3f interpolate(float t, int currentIndex, FrameInterpolator.TrackDataReader<Vector3f> data, FrameInterpolator.TrackTimeReader times, Vector3f store) {
                data.getEntryClamp(currentIndex, store);
                data.getEntryClamp(currentIndex + 1, this.next);
                store.interpolateLocal(this.next, t);
                return store;
            }
        };
    }

    private AnimInterpolators() {
    }

    public static class CatmullRomInterpolator
    extends AnimInterpolator<Vector3f> {
        private final Vector3f p0 = new Vector3f();
        private final Vector3f p1 = new Vector3f();
        private final Vector3f p2 = new Vector3f();
        private final Vector3f p3 = new Vector3f();
        private float tension = 0.7f;

        public CatmullRomInterpolator(float tension) {
            this.tension = tension;
        }

        public CatmullRomInterpolator() {
        }

        @Override
        public Vector3f interpolate(float t, int currentIndex, FrameInterpolator.TrackDataReader<Vector3f> data, FrameInterpolator.TrackTimeReader times, Vector3f store) {
            data.getEntryModSkip(currentIndex - 1, this.p0);
            data.getEntryModSkip(currentIndex, this.p1);
            data.getEntryModSkip(currentIndex + 1, this.p2);
            data.getEntryModSkip(currentIndex + 2, this.p3);
            FastMath.interpolateCatmullRom(t, this.tension, this.p0, this.p1, this.p2, this.p3, store);
            return store;
        }
    }

    public static class TimeInterpolator
    extends AnimInterpolator<Float> {
        private final EaseFunction ease;

        public TimeInterpolator(EaseFunction ease) {
            this.ease = ease;
        }

        @Override
        public Float interpolate(float t, int currentIndex, FrameInterpolator.TrackDataReader<Float> data, FrameInterpolator.TrackTimeReader times, Float store) {
            return Float.valueOf(this.ease.apply(t));
        }
    }
}

