/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mworld.db;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.simsilica.mworld.LeafData;
import com.simsilica.mworld.LeafId;
import com.simsilica.mworld.db.LeafDb;
import com.simsilica.util.CacheTracker;
import java.util.concurrent.TimeUnit;

public class LeafDbCache
implements LeafDb {
    private LeafDb delegate;
    private LoadingCache<LeafId, LeafData> cache;

    public LeafDbCache(LeafDb delegate) {
        this(delegate, 1000);
    }

    public LeafDbCache(LeafDb delegate, int cacheSize) {
        this.delegate = delegate;
        this.cache = CacheBuilder.newBuilder().maximumSize((long)cacheSize).expireAfterAccess(10L, TimeUnit.MINUTES).recordStats().build((CacheLoader)new LeafCacheLoader());
        CacheTracker.track(this.cache, (String)("LeafDbCache@" + System.identityHashCode(this)), (boolean)true);
    }

    @Override
    public LeafData loadLeaf(LeafId leafId) {
        return (LeafData)this.cache.getUnchecked((Object)leafId);
    }

    @Override
    public void storeLeaf(LeafData leaf) {
        this.cache.put((Object)leaf.getInfo().leafId, (Object)leaf);
        this.delegate.storeLeaf(leaf);
    }

    public LeafData getCachedLeaf(LeafId leafId) {
        return (LeafData)this.cache.getIfPresent((Object)leafId);
    }

    private class LeafCacheLoader
    extends CacheLoader<LeafId, LeafData> {
        private LeafCacheLoader() {
        }

        public LeafData load(LeafId key) {
            return LeafDbCache.this.delegate.loadLeaf(key);
        }
    }
}

