/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mworld.tile.pc;

import com.simsilica.ethereal.io.BitInputStream;
import com.simsilica.ethereal.io.BitOutputStream;
import com.simsilica.mworld.tile.pc.Point;
import com.simsilica.mworld.tile.pc.PointCloudData;
import com.simsilica.mworld.tile.pc.PointType;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PointCloudDataProtocol {
    static Logger log = LoggerFactory.getLogger(PointCloudDataProtocol.class);
    private int version = 1;
    private int xBits;
    private int yBits;
    private int zBits;

    public PointCloudDataProtocol() {
        this(5, 10, 5);
    }

    public PointCloudDataProtocol(int xBits, int yBits, int zBits) {
        this.xBits = xBits;
        this.yBits = yBits;
        this.zBits = zBits;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(PointCloudData pc, OutputStream rawOut) throws IOException {
        try (BitOutputStream out = new BitOutputStream(rawOut);){
            this.write(pc, out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PointCloudData read(InputStream rawIn) throws IOException {
        try (BitInputStream in = new BitInputStream(rawIn);){
            PointCloudData pointCloudData = this.read(in);
            return pointCloudData;
        }
    }

    public void write(PointCloudData pc, BitOutputStream out) throws IOException {
        out.writeBits(this.version, 16);
        out.writeBits(pc.getOriginX(), 10);
        out.writeBits(pc.getOriginZ(), 10);
        Map<PointType, Point[]> points = pc.getPoints();
        out.writeBits(points.size(), 8);
        for (Map.Entry<PointType, Point[]> e : pc.getPoints().entrySet()) {
            out.writeBits((int)e.getKey().getTypeIndex(), 8);
            this.writePoints(e.getValue(), out);
        }
    }

    public PointCloudData read(BitInputStream in) throws IOException {
        int version = in.readBits(16);
        int xOrigin = in.readBits(10);
        int zOrigin = in.readBits(10);
        PointCloudData result = new PointCloudData(xOrigin, zOrigin);
        int layerCount = in.readBits(8);
        for (int i = 0; i < layerCount; ++i) {
            byte typeIndex = (byte)in.readBits(8);
            Point[] points = this.readPoints(in);
            result.setPoints(new PointType(typeIndex), points);
        }
        return result;
    }

    protected void writePoints(Point[] array, BitOutputStream out) throws IOException {
        int size = array.length;
        int maxSize = 524287;
        if (size > maxSize) {
            log.error("Point cloud size exceeds 19 bits, size:" + size + "  max:" + maxSize + "  Clamping.");
            size = maxSize;
        }
        out.writeBits(size, 19);
        for (Point p : array) {
            this.writePoint(p, out);
        }
    }

    protected Point[] readPoints(BitInputStream in) throws IOException {
        int size = in.readBits(19);
        Point[] points = new Point[size];
        for (int i = 0; i < size; ++i) {
            points[i] = this.readPoint(in);
        }
        return points;
    }

    public void writePoint(Point p, BitOutputStream out) throws IOException {
        out.writeBits((int)p.x, this.xBits);
        out.writeBits((int)p.y, this.yBits);
        out.writeBits((int)p.z, this.zBits);
        out.writeBits((int)p.index, 8);
        out.writeBits((int)p.light, 16);
        out.writeBits((int)p.direction, 6);
    }

    public Point readPoint(BitInputStream in) throws IOException {
        Point p = new Point();
        p.x = (byte)in.readBits(this.xBits);
        p.y = (short)in.readBits(this.yBits);
        p.z = (byte)in.readBits(this.zBits);
        p.index = (byte)in.readBits(8);
        p.light = (short)in.readBits(16);
        p.direction = (byte)in.readBits(6);
        return p;
    }
}

