/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.ethereal.zone;

import com.simsilica.ethereal.zone.ZoneKey;
import com.simsilica.mathd.Vec3d;
import com.simsilica.mathd.Vec3i;

public class ZoneGrid {
    private Vec3i zoneSize;

    public ZoneGrid(int zoneSize) {
        this(new Vec3i(zoneSize, zoneSize, zoneSize));
    }

    public ZoneGrid(int xZoneSize, int yZoneSize, int zZoneSize) {
        this(new Vec3i(xZoneSize, yZoneSize, zZoneSize));
    }

    public ZoneGrid(Vec3i sizes) {
        this.zoneSize = sizes;
    }

    public Vec3i getZoneSize() {
        return this.zoneSize;
    }

    private int worldToZone(int i, int size) {
        if (size == 0) {
            return 0;
        }
        if (i < 0) {
            i = (i + 1) / size;
            return i - 1;
        }
        return i / size;
    }

    private int worldToZone(double d, int size) {
        return this.worldToZone((int)Math.floor(d), size);
    }

    public Vec3i worldToZone(double x, double y, double z) {
        int i = this.worldToZone(x, this.zoneSize.x);
        int j = this.worldToZone(y, this.zoneSize.y);
        int k = this.worldToZone(z, this.zoneSize.z);
        return new Vec3i(i, j, k);
    }

    public Vec3i worldToZone(Vec3d world) {
        int i = this.worldToZone(world.x, this.zoneSize.x);
        int j = this.worldToZone(world.y, this.zoneSize.y);
        int k = this.worldToZone(world.z, this.zoneSize.z);
        return new Vec3i(i, j, k);
    }

    private int zoneToWorld(int i, int size) {
        return i * size;
    }

    public Vec3i zoneToWorld(int x, int y, int z) {
        int i = this.zoneToWorld(x, this.zoneSize.x);
        int j = this.zoneToWorld(y, this.zoneSize.y);
        int k = this.zoneToWorld(z, this.zoneSize.z);
        return new Vec3i(i, j, k);
    }

    public ZoneKey worldToKey(Vec3d pos) {
        return this.worldToKey(pos.x, pos.y, pos.z);
    }

    public ZoneKey worldToKey(double x, double y, double z) {
        int i = this.worldToZone(x, this.zoneSize.x);
        int j = this.worldToZone(y, this.zoneSize.y);
        int k = this.worldToZone(z, this.zoneSize.z);
        return new ZoneKey(this, i, j, k);
    }

    public Vec3i zoneToWorld(ZoneKey key) {
        return key.origin.clone();
    }

    public long toLongId(ZoneKey key) {
        long x = (long)key.x & 0x1FFFFFL;
        long y = (long)key.y & 0x1FFFFFL;
        long z = (long)key.z & 0x1FFFFFL;
        return x << 42 | y << 21 | z;
    }

    public ZoneKey fromLongId(long id) {
        int x;
        int y;
        int z = (int)(id & 0x1FFFFFL);
        if ((z & 0x100000) != 0) {
            z |= 0xFFF00000;
        }
        if (((y = (int)(id >>> 21 & 0x1FFFFFL)) & 0x100000) != 0) {
            y |= 0xFFF00000;
        }
        if (((x = (int)(id >>> 42 & 0x1FFFFFL)) & 0x100000) != 0) {
            x |= 0xFFF00000;
        }
        return new ZoneKey(this, x, y, z);
    }

    public static void main(String ... args) {
        ZoneKey[] test;
        ZoneGrid grid = new ZoneGrid(32);
        int maxValue = 1048575;
        int minValue = -1048575;
        for (ZoneKey k : test = new ZoneKey[]{new ZoneKey(grid, 0, 0, 0), new ZoneKey(grid, 1, 1, 1), new ZoneKey(grid, 1, -1, 0), new ZoneKey(grid, 100, 100, 100), new ZoneKey(grid, -1, -1, -1), new ZoneKey(grid, -100, -100, -100), new ZoneKey(grid, maxValue, maxValue, maxValue), new ZoneKey(grid, minValue, minValue, minValue)}) {
            System.out.println("Key:" + k);
            long id = grid.toLongId(k);
            System.out.println("    id:" + id + "  " + Long.toHexString(id));
            System.out.println("    reverse:" + grid.fromLongId(id));
        }
    }

    public String toString() {
        return "Grid[" + this.zoneSize + "]";
    }
}

