/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.util;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheStats;
import java.io.PrintWriter;
import java.util.Map;
import java.util.TreeMap;
import java.util.WeakHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheTracker {
    static Logger log = LoggerFactory.getLogger(CacheTracker.class);
    private static WeakHashMap<Cache<?, ?>, CacheInfo> caches = new WeakHashMap();

    public static void track(Cache<?, ?> cache, String name, boolean reportStats) {
        CacheInfo existing = caches.get(cache);
        if (existing != null) {
            throw new IllegalArgumentException("Cache:" + name + " is already tracked as:" + existing.name);
        }
        CacheInfo info = new CacheInfo(name, reportStats);
        caches.put(cache, info);
    }

    public static void generateSizeReport(PrintWriter out, String indent) {
        TreeMap<String, Long> sizes = new TreeMap<String, Long>();
        for (Map.Entry<Cache<?, ?>, CacheInfo> entry : caches.entrySet()) {
            Cache<?, ?> key = entry.getKey();
            if (key == null) continue;
            sizes.put(entry.getValue().name, key.size());
        }
        for (Map.Entry<Object, CacheInfo> entry : sizes.entrySet()) {
            out.println(indent + String.format("%s:%,d", entry.getKey(), entry.getValue()));
        }
    }

    public static void generateStatsReport(PrintWriter out, String indent) {
        TreeMap<String, CombinedStats> sizes = new TreeMap<String, CombinedStats>();
        for (Map.Entry<Cache<?, ?>, CacheInfo> entry : caches.entrySet()) {
            Cache<?, ?> key = entry.getKey();
            if (key == null || !entry.getValue().reportStats) continue;
            sizes.put(entry.getValue().name, new CombinedStats(key.size(), key.stats()));
        }
        for (Map.Entry<Object, CacheInfo> entry : sizes.entrySet()) {
            CombinedStats cs = (CombinedStats)((Object)entry.getValue());
            out.println(indent + String.format("%s:%,d stats:%s", entry.getKey(), cs.size, cs.cacheStats));
        }
    }

    protected static class CombinedStats {
        private long size;
        private CacheStats cacheStats;

        protected CombinedStats(long size, CacheStats cacheStats) {
            this.size = size;
            this.cacheStats = cacheStats;
        }
    }

    protected static class CacheInfo {
        private String name;
        private boolean reportStats;

        protected CacheInfo(String name, boolean reportStats) {
            this.name = name;
            this.reportStats = reportStats;
        }
    }
}

