
import com.google.common.collect.*;
import com.simsilica.es.sql.PersistentEntityIdGenerator;

// We use GSON because groovy's is too smart with meta-classes
import com.google.gson.*;

import com.simsilica.crig.es.*;
import com.simsilica.mworld.db.ParentIdFileFunction;
import mythruna.es.debug.*;
import mythruna.es.vars.*;
import mythruna.world.es.*;

// This is not the best way to do this because we will have to remember
// to always keep it up-to-date.
allComponents = [
    CreatedBy.class,
    Name.class,
    ActivationCount.class,
    AgentType.class,
    AssemblyBlueprintInfo.class,
    AttachedTo.class,
    BlueprintInfo.class,
    BlueprintSource.class,
    BodyEffect.class,
    BodyType.class,
    CharacterName.class,
    CharacterRelationship.class,
    ChildOf.class,
    ClaimArea.class,
    ClaimMarker.class,
    ClaimPermissions.class,
    ClaimType.class,
    ClothingInfo.class,
    ContainedIn.class,
    ContainerVolume.class,
    CreationTime.class,
    CustomMapLine.class,
    CustomMapMarker.class,
    DebugShape.class,
    DebugText.class,
    EncounterTrigger.class,
    EntityLink.class,
    HairColor.class,
    Holding.class,
    LocationRelationship.class,
    MapMarker.class,
    MapToolType.class,
    Morph.class,
    MorphAnimation.class,
    MovementInput.class,
    ObjectFocus.class,
    ObjectName.class,
    ObjectTypeInfo.class,
    ObjectVolume.class,
    OwnedBy.class,
    PortalLink.class,
    ProtectedArea.class,
    Quest.class,
    QuestObjective.class,
    RelativeLocation.class,
    Race.class,
    ScheduledAction.class,
    ScheduledTime.class,
    SkinColor.class,
    SkinVariation.class,
    SoundInfo.class,
    StatusText.class,
    StructureInfo.class,
    SubstanceCounter.class,
    TemporaryObject.class,
    TriggerActive.class,
    TriggerInfo.class,
    IntVariable.class,
    LongVariable.class,
    StringVariable.class,
    VehicleInput.class,
    VisionEffect.class,
    WornBy.class,
    WorldAge.class,
    WorldSeed.class,
    BodyPosition.class,
    LargeGridCell.class,
    LargeObject.class,
    AnimationConfig.class,
    Gravity.class,
    Impulse.class,
    Mass.class,
    ShapeInfo.class,
    SpawnPosition.class,
] as Class[];

allPersistentComponents = [] as Set;
allComponents.each { Class type ->
    if( PersistentComponent.class.isAssignableFrom(type) ) {
        if( !allPersistentComponents.add(type) ) {
            //log.info("Duplicate:" + type);
        }
    }
}
allPersistentComponents = allPersistentComponents.toArray(new Class[0]);

def gson = new GsonBuilder().setPrettyPrinting().create();
toJson = { Object obj ->
    return gson.toJson(obj);
}

fromJson = { String json, Class type ->
    return gson.fromJson(json, type);
}

entityToMap = { id, types ->
    def record = new TreeMap();
    types.each { type ->
        def name = type.simpleName;
        def val = entityData.getComponent(id, type);
        if( val ) {
            record.put(name, val);
        }
    }

    if( record.isEmpty() ) {
        return record;
    }
    record.put("entityId", id.id);
    record.put("entityName", id.name);
    record.put("entityType", id.type?.name);
    return record;
}

writeEntityJsonToFile = { file, types, ids ->
    def records = [];
    ids.each {
        records.add(entityToMap(it, types));
    }
    file.text = toJson(records);
}

writeEntityMapJsonToFile = { file, types, map ->
    def result = [:];
    map.entrySet().each { entry ->
        def records = [];
        result[entry.key] = records;
        entry.value.each {
            records.add(entityToMap(it, types));
        }
    }
    file.text = toJson(result);
}

writeEntityCsv = { file, types, ids ->
    def typeNames = new TreeSet();
    types.each { componentType ->
        typeNames.add(componentType.simpleName);
    }

    file.withPrintWriter { report ->

        report.print("id");
        typeNames.each {
            report.print("," + it);
        }
        report.println();

        def record = new TreeMap();

        int count = 0;
        int total = ids.size();
        ids.each { id ->
            count++;
            if( (count % 100) == 0 ) {
                log.info(String.format("%.01f%%", 100.0 * count/total));
            }

            record.clear();
            types.each { type ->
                def name = type.simpleName;
                def val = entityData.getComponent(id, type);
                if( val ) {
                    record.put(name, val);
                }
            }
            if( !record.isEmpty() ) {
                report.print(id.id);
                typeNames.each { name ->
                    def val = record.get(name);
                    if( val ) {
                        String s = "Y";
                        if( val instanceof Name ) {
                            s = val.name.replace(",", " ");
                        } else if( val instanceof ObjectName ) {
                            s = val.getName(entityData).replace(",", " ");
                        } else if( val instanceof ObjectTypeInfo ) {
                            s = val.getTypeName(entityData).replace(",", " ");
                        } else if( val instanceof OwnedBy ) {
                            s = String.valueOf(val.owner.id);
                        } else if( val instanceof CreatedBy ) {
                            s = String.valueOf(val.creatorId.id);
                        } else if( val instanceof SpawnPosition ) {
                            def pos = val.location;
                            s = String.format("[%f %f %f]", pos.x, pos.y, pos.z);
                        }
                        report.print("," + s);
                    } else {
                        report.print(",");
                    }
                }
                report.println();
            }
        }
    }

}


