

cleanupBadCornerMarkers = {
    entityData.findEntities(ObjectTypeInfo.typeFilter("CornerMarker"), ObjectTypeInfo, Name).each {
        if( !it[ClaimMarker] ) {
            log.info("cleaning:" + it + " name:" + it[Name]);
            entityData.removeEntity(it);
        }
    }
}

def versionKey = "cornerMarkers.data.version";
def version = worldManager.worldEntity.vars.loadInt(versionKey, -1);
def latestVersion = 1;

log.info(versionKey + ":" + version);
if( version < 1 ) {
    log.info("Need to cleanup bad corner markers.");
    cleanupBadCornerMarkers();
}

if( version < latestVersion ) {
    // Mark it as upgraded
    log.info("Setting " + versionKey + " to:" + latestVersion);
    worldManager.worldEntity.vars.storeInt(versionKey, latestVersion);
}




