/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mphys;

import com.google.common.base.MoreObjects;
import com.simsilica.mathd.Quatd;
import com.simsilica.mathd.Vec3d;
import com.simsilica.mphys.AbstractShape;

public class AbstractBody<K, S extends AbstractShape> {
    public K id;
    public S shape;
    public final Vec3d position = new Vec3d();
    public final Quatd orientation = new Quatd();

    protected AbstractBody() {
    }

    protected AbstractBody(K id, S shape) {
        this.id = id;
        this.shape = shape;
    }

    protected AbstractBody(K id, S shape, Vec3d position, Quatd orientation) {
        this(id, shape);
        this.position.set(position);
        this.orientation.set(orientation);
    }

    protected void setShape(S shape) {
        this.shape = shape;
    }

    public final Vec3d worldToLocal(Vec3d point, Vec3d store) {
        if (store == null) {
            store = point.subtract(this.position);
        } else {
            store.set(point).subtractLocal(this.position);
        }
        this.orientation.inverse().mult(store, store);
        return store;
    }

    public Vec3d localToWorld(Vec3d point, Vec3d store) {
        store = store == null ? this.orientation.mult(point) : this.orientation.mult(point, store);
        store.addLocal(this.position);
        return store;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)this.getClass().getSimpleName()).add("id", this.id).add("position", (Object)this.position).add("orientation", (Object)this.orientation).add("shape", this.shape).toString();
    }
}

