/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.io;

import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BytePacketInputStream
extends InputStream {
    static Logger log = LoggerFactory.getLogger(BytePacketInputStream.class);
    private final byte[][] packets;
    private final int totalSize;
    private int nextPacketIndex = 0;
    private byte[] currentPacket;
    private int packetOffset;
    private int bytesRead;

    public BytePacketInputStream(byte[][] packets) {
        this.packets = packets;
        int size = 0;
        for (byte[] packet : packets) {
            size += packet.length;
        }
        this.totalSize = size;
        this.nextPacket();
    }

    @Override
    public void close() {
        this.bytesRead = this.totalSize;
    }

    @Override
    public int available() {
        return this.totalSize - this.bytesRead;
    }

    protected void nextPacket() {
        if (this.nextPacketIndex == this.packets.length) {
            this.currentPacket = null;
            return;
        }
        this.currentPacket = this.packets[this.nextPacketIndex++];
        this.packetOffset = 0;
    }

    @Override
    public int read() {
        if (this.bytesRead >= this.totalSize) {
            return -1;
        }
        if (this.packetOffset == this.currentPacket.length) {
            this.nextPacket();
        }
        ++this.bytesRead;
        return this.currentPacket[this.packetOffset++] & 0xFF;
    }

    @Override
    public int read(byte[] b, int off, int len) {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException();
        }
        if (len <= 0) {
            return 0;
        }
        if (this.bytesRead >= this.totalSize) {
            return -1;
        }
        int result = 0;
        while (len > 0) {
            if (this.packetOffset == this.currentPacket.length) {
                this.nextPacket();
            }
            if (this.currentPacket == null) break;
            int toCopy = Math.min(len, this.currentPacket.length - this.packetOffset);
            System.arraycopy(this.currentPacket, this.packetOffset, b, off, toCopy);
            this.packetOffset += toCopy;
            off += toCopy;
            len -= toCopy;
            this.bytesRead += toCopy;
            result += toCopy;
        }
        return result;
    }
}

