/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mworld.db;

import com.simsilica.mworld.ColumnChangeEvent;
import com.simsilica.mworld.ColumnChangeListener;
import com.simsilica.mworld.ColumnData;
import com.simsilica.mworld.ColumnId;
import com.simsilica.mworld.db.AbstractColumnDb;
import com.simsilica.mworld.db.ColumnDb;
import com.simsilica.mworld.db.ColumnGeneratedEvent;
import com.simsilica.mworld.db.ColumnGenerationListener;
import com.simsilica.mworld.db.ObservableColumnDb;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObservableColumnDbAdapter
extends AbstractColumnDb
implements ObservableColumnDb {
    static Logger log = LoggerFactory.getLogger(ObservableColumnDbAdapter.class);
    private ColumnDb delegate;
    private boolean initialized;
    private List<ColumnChangeListener> listeners = new ArrayList<ColumnChangeListener>();
    private ColumnChangeListener[] listenerArray = null;
    private List<ColumnGenerationListener> genListeners = new ArrayList<ColumnGenerationListener>();
    private ColumnGenerationListener[] genListenerArray = null;
    private ColumnGenerationListener originalHook;

    public ObservableColumnDbAdapter(ColumnDb delegate) {
        this.delegate = delegate;
    }

    @Override
    public void initialize() {
        if (this.initialized) {
            log.warn("initialize(): Double initialization");
            return;
        }
        log.info("initialize()");
        this.originalHook = this.delegate.getGenerationHook();
        this.delegate.setGenerationHook(new ColumnGenerationListener(){

            @Override
            public void columnGenerated(ColumnGeneratedEvent event) {
                ObservableColumnDbAdapter.this.fireColumnGenerated(event);
            }
        });
        this.delegate.initialize();
        this.initialized = true;
    }

    @Override
    public void terminate() {
        if (!this.initialized) {
            log.warn("terminate(): Not initialized");
            return;
        }
        log.info("terminate()");
        this.delegate.terminate();
        this.delegate.setGenerationHook(this.originalHook);
        this.originalHook = null;
        this.initialized = false;
    }

    @Override
    public ColumnData getColumn(ColumnId columnId) {
        if (!this.initialized) {
            throw new IllegalStateException("Not initialized");
        }
        return this.delegate.getColumn(columnId);
    }

    @Override
    public void addColumnChangeListener(ColumnChangeListener l) {
        this.listeners.add(l);
        this.listenerArray = null;
    }

    @Override
    public void removeColumnChangeListener(ColumnChangeListener l) {
        this.listeners.remove(l);
        this.listenerArray = null;
    }

    protected ColumnChangeListener[] getListeners() {
        if (this.listenerArray == null) {
            this.listenerArray = this.listeners.toArray(new ColumnChangeListener[0]);
        }
        return this.listenerArray;
    }

    @Override
    public void addColumnGenerationListener(ColumnGenerationListener l) {
        this.genListeners.add(l);
        this.genListenerArray = null;
    }

    @Override
    public void removeColumnGenerationListener(ColumnGenerationListener l) {
        this.genListeners.remove(l);
        this.genListenerArray = null;
    }

    protected ColumnGenerationListener[] getGenListeners() {
        if (this.genListenerArray == null) {
            this.genListenerArray = this.genListeners.toArray(new ColumnGenerationListener[0]);
        }
        return this.genListenerArray;
    }

    @Override
    public void markChanged(ColumnData col) {
        if (!this.initialized) {
            throw new IllegalStateException("Not initialized");
        }
        this.delegate.markChanged(col);
        this.fireColumnChanged(col, false);
    }

    @Override
    public void resetColumn(ColumnId columnId) {
        log.info("resetColumn(" + columnId + ")");
        this.delegate.resetColumn(columnId);
        ColumnData col = this.getColumn(columnId);
        this.fireColumnChanged(col, true);
    }

    @Override
    public void reloadColumn(ColumnId columnId) {
        log.info("reloadColumn(" + columnId + ")");
        this.delegate.reloadColumn(columnId);
        ColumnData col = this.getColumn(columnId);
        this.fireColumnChanged(col, true);
    }

    protected void fireColumnChanged(ColumnData col, boolean reset) {
        if (this.listeners.isEmpty()) {
            return;
        }
        ColumnChangeEvent event = new ColumnChangeEvent(col.getColumnId(), col.getVersion().getVersion(), reset);
        for (ColumnChangeListener l : this.getListeners()) {
            try {
                l.columnChanged(event);
            }
            catch (RuntimeException e) {
                log.error("Error from listener:" + l, (Throwable)e);
            }
        }
    }

    protected void fireColumnGenerated(ColumnData col) {
        if (this.genListeners.isEmpty()) {
            return;
        }
        ColumnGeneratedEvent event = new ColumnGeneratedEvent(col);
        this.fireColumnGenerated(event);
    }

    protected void fireColumnGenerated(ColumnGeneratedEvent event) {
        for (ColumnGenerationListener l : this.getGenListeners()) {
            try {
                l.columnGenerated(event);
            }
            catch (RuntimeException e) {
                log.error("Error from listener:" + l, (Throwable)e);
            }
        }
    }
}

