/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.network.service.rpc;

import com.jme3.network.Client;
import com.jme3.network.ClientStateListener;
import com.jme3.network.ErrorListener;
import com.jme3.network.service.AbstractClientService;
import com.jme3.network.service.ClientServiceManager;
import com.jme3.network.service.rpc.RpcConnection;
import com.jme3.network.service.rpc.RpcHandler;
import com.jme3.network.util.ObjectMessageDelegator;
import java.util.logging.Logger;

public class RpcClientService
extends AbstractClientService {
    private static final Logger log = Logger.getLogger(RpcClientService.class.getName());
    private RpcConnection rpc;
    private ObjectMessageDelegator delegator;
    private TerminationHandler terminationHandler = new TerminationHandler();

    public RpcConnection getRpcConnection() {
        return this.rpc;
    }

    @Override
    protected void onInitialize(ClientServiceManager serviceManager) {
        Client client = serviceManager.getClient();
        this.rpc = new RpcConnection(client);
        this.delegator = new ObjectMessageDelegator(this.rpc, true);
        client.addMessageListener(this.delegator, this.delegator.getMessageTypes());
        client.addClientStateListener(this.terminationHandler);
        client.addErrorListener(this.terminationHandler);
    }

    @Override
    public void terminate(ClientServiceManager serviceManager) {
        Client client = serviceManager.getClient();
        client.removeMessageListener(this.delegator, this.delegator.getMessageTypes());
        client.removeClientStateListener(this.terminationHandler);
        client.removeErrorListener(this.terminationHandler);
        this.rpc.close();
    }

    public Object callAndWait(byte channel, short objId, short procId, Object ... args) {
        return this.rpc.callAndWait(channel, objId, procId, args);
    }

    public void callAsync(byte channel, short objId, short procId, Object ... args) {
        this.rpc.callAsync(channel, objId, procId, args);
    }

    public void registerHandler(short objId, RpcHandler handler) {
        this.rpc.registerHandler(objId, handler);
    }

    public void removeHandler(short objId, RpcHandler handler) {
        this.rpc.removeHandler(objId, handler);
    }

    protected class TerminationHandler
    implements ClientStateListener,
    ErrorListener<Client> {
        protected TerminationHandler() {
        }

        @Override
        public void handleError(Client source, Throwable t) {
            RpcClientService.this.rpc.close();
        }

        @Override
        public void clientConnected(Client c) {
        }

        @Override
        public void clientDisconnected(Client c, ClientStateListener.DisconnectInfo info) {
            RpcClientService.this.rpc.close();
        }
    }
}

