/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.action;

import com.google.common.base.MoreObjects;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Option<T> {
    static Logger log = LoggerFactory.getLogger(Option.class);
    private T target;
    private String display;
    private String actionId;
    private Object[] parms;

    private Option() {
    }

    public Option(String actionId, Object ... parms) {
        this(null, null, actionId, parms);
    }

    public Option(String display, String actionId, Object ... parms) {
        this(null, display, actionId, parms);
    }

    public Option(T target, String actionId, Object ... parms) {
        this(target, null, actionId, parms);
    }

    public Option(T target, String display, String actionId, Object ... parms) {
        this.target = target;
        this.display = display;
        this.actionId = actionId;
        this.parms = parms;
    }

    public T getTarget() {
        return this.target;
    }

    public String getDisplay() {
        return this.display == null ? this.toDisplay(this.actionId) : this.display;
    }

    public String getActionId() {
        return this.actionId;
    }

    public Object[] getParameters() {
        return this.parms;
    }

    protected String toDisplay(String id) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < id.length(); ++i) {
            char c = id.charAt(i);
            if (i == 0) {
                c = Character.toUpperCase(c);
            } else if (Character.isUpperCase(c)) {
                sb.append(" ");
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)this.getClass().getSimpleName()).add("target", this.target).add("display", (Object)this.display).add("actionId", (Object)this.actionId).add("parameters", Arrays.asList(this.parms)).toString();
    }
}

