/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.namegen;

import com.simsilica.namegen.ClusterType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Cluster
implements Comparable<Cluster>,
Serializable {
    static Logger log = LoggerFactory.getLogger(Cluster.class);
    private static final long serialVersionUID = 42L;
    private String letters;
    private ClusterType type;

    private Cluster() {
    }

    public Cluster(String letters, ClusterType type) {
        this.letters = letters;
        this.type = type;
    }

    public String getLetters() {
        return this.letters;
    }

    public ClusterType getType() {
        return this.type;
    }

    public static List<Cluster> toClusters(String phrase) {
        ArrayList<Cluster> results = new ArrayList<Cluster>();
        ClusterType lastType = ClusterType.Start;
        int len = phrase.length();
        StringBuilder current = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            char c = phrase.charAt(i);
            ClusterType type = ClusterType.getType(c);
            if (type == lastType) {
                current.append(c);
            } else {
                if (lastType != ClusterType.Start) {
                    results.add(new Cluster(current.toString(), lastType));
                }
                current.setLength(0);
                current.append(c);
            }
            lastType = type;
        }
        if (current.length() > 0) {
            results.add(new Cluster(current.toString(), lastType));
        }
        return results;
    }

    public static String toWords(List<Cluster> clusters) {
        StringBuilder sb = new StringBuilder();
        for (Cluster cluster : clusters) {
            if (cluster.type == ClusterType.Start) continue;
            sb.append(cluster.letters);
        }
        return sb.toString();
    }

    @Override
    public int compareTo(Cluster other) {
        int i = this.letters.compareTo(other.letters);
        if (i != 0) {
            return i;
        }
        return this.type.compareTo(other.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.letters});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        Cluster other = (Cluster)o;
        if (other.type != this.type) {
            return false;
        }
        return Objects.equals(other.letters, this.letters);
    }

    public String toString() {
        return "['" + this.letters + "', " + (Object)((Object)this.type) + "]";
    }
}

