/*
 * Decompiled with CFR 0.152.
 */
package mythruna.character;

import com.simsilica.namegen.Cluster;
import java.util.List;
import java.util.Random;
import java.util.function.Function;
import mythruna.character.RaceType;
import mythruna.character.RaceTypeIndex;
import mythruna.world.name.NameGeneratorCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CharacterNameGenerator {
    static Logger log = LoggerFactory.getLogger(CharacterNameGenerator.class);
    public static final String HUMAN_NAMES = "races/human-name-stems.txt";
    private RaceTypeIndex races;

    private CharacterNameGenerator(RaceTypeIndex races) {
        this.races = races;
    }

    public static CharacterNameGenerator create(RaceTypeIndex races, Function<String, String> textFunc) {
        return new CharacterNameGenerator(races);
    }

    public String[] generateName(String race, Random rand) {
        RaceType type;
        String key = "/people/all-male.nameset";
        if (race != null && (type = this.races.getRace(race)) != null && "Female".equals(type.getSubtype())) {
            key = "/people/all-female.nameset";
        }
        List first = NameGeneratorCache.getGenerator(key).generateWord(2, 8, rand);
        List last = NameGeneratorCache.getGenerator("/people/all-last.nameset").generateWord(2, 10, rand);
        return new String[]{Cluster.toWords((List)first), Cluster.toWords((List)last)};
    }
}

