/*
 * Decompiled with CFR 0.152.
 */
package mythruna.net.client;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.jme3.network.service.AbstractClientService;
import com.jme3.network.service.ClientServiceManager;
import com.jme3.network.service.rmi.RmiClientService;
import com.simsilica.es.EntityId;
import com.simsilica.mblock.CellArray;
import com.simsilica.mworld.io.CellArrayProtocol;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import mythruna.net.DestructibleSession;
import mythruna.net.DestructibleSessionListener;
import mythruna.sim.DestructibleListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DestructibleSessionClientService
extends AbstractClientService
implements DestructibleSession {
    static Logger log = LoggerFactory.getLogger(DestructibleSessionClientService.class);
    private static final CellArray NULL_MARKER = new CellArray(0);
    private RmiClientService rmiService;
    private byte channel;
    private DestructibleSession delegate;
    private LoadingCache<EntityId, CellArray> cellArrayCache;
    private DestructibleSessionCallback sessionCallback = new DestructibleSessionCallback();
    private List<DestructibleListener> listeners = new CopyOnWriteArrayList<DestructibleListener>();

    public DestructibleSessionClientService(int channel) {
        this.channel = (byte)channel;
        this.cellArrayCache = CacheBuilder.newBuilder().weakValues().build((CacheLoader)new CacheLoader<EntityId, CellArray>(){

            public CellArray load(EntityId key) {
                DestructibleSessionClientService.this.threadCheck();
                byte[] bytes = DestructibleSessionClientService.this.getObjectCellBytes(key);
                return bytes == null ? NULL_MARKER : CellArrayProtocol.fromBytes((byte[])bytes);
            }
        });
    }

    protected void threadCheck() {
        if ("jME3 Main".equals(Thread.currentThread().getName())) {
            log.error("long-style query, cache miss on render thread", new Throwable("stack-trace"));
        }
    }

    private DestructibleSession getDelegate() {
        if (this.delegate == null) {
            this.delegate = (DestructibleSession)this.rmiService.getRemoteObject(DestructibleSession.class);
            log.info("delegate:" + this.delegate);
            if (this.delegate == null) {
                throw new RuntimeException("No DestructibleSession found");
            }
        }
        return this.delegate;
    }

    public void addDestructibleListener(DestructibleListener l) {
        this.listeners.add(l);
    }

    public void removeDestructibleListener(DestructibleListener l) {
        this.listeners.remove(l);
    }

    protected void onInitialize(ClientServiceManager s) {
        log.info("onInitialize(" + s + ")");
        this.rmiService = (RmiClientService)this.getService(RmiClientService.class);
        if (this.rmiService == null) {
            throw new RuntimeException("RMI service required");
        }
        this.rmiService.share(this.channel, (Object)this.sessionCallback, DestructibleSessionListener.class);
    }

    public void start() {
        log.info("start()");
        super.start();
    }

    @Override
    public byte[] getObjectCellBytes(EntityId objectId) {
        this.threadCheck();
        return this.getDelegate().getObjectCellBytes(objectId);
    }

    @Override
    public CellArray getObjectCellArray(EntityId objectId) {
        CellArray result = (CellArray)this.cellArrayCache.getUnchecked((Object)objectId);
        return result == NULL_MARKER ? null : result;
    }

    private class DestructibleSessionCallback
    implements DestructibleSessionListener {
        private DestructibleSessionCallback() {
        }

        @Override
        public void objectCellChanged(EntityId entityId, int x, int y, int z, int value) {
            log.info("objectCellChanged(" + entityId + ", " + x + ", " + y + ", " + z + ", " + value + ")");
            for (DestructibleListener l : DestructibleSessionClientService.this.listeners) {
                l.cellChanged(entityId, x, y, z, value);
            }
        }
    }
}

