/*
 * Decompiled with CFR 0.152.
 */
package mythruna.jme3;

import com.jme3.effect.shapes.EmitterShape;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.util.clone.Cloner;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RadialEmitterShape
implements EmitterShape {
    static Logger log = LoggerFactory.getLogger(RadialEmitterShape.class);
    private Vector3f center;
    private Vector2f size;

    public RadialEmitterShape() {
    }

    public RadialEmitterShape(Vector3f center, Vector2f size) {
        this.center = center;
        this.size = size;
    }

    public void getRandomPoint(Vector3f store) {
        this.getRandomPointAndNormal(store, null);
    }

    public void getRandomPointAndNormal(Vector3f store, Vector3f normal) {
        double rads = Math.random() * Math.PI * 2.0;
        double x = Math.cos(rads);
        double y = Math.sin(rads);
        if (normal != null) {
            normal.set((float)x, (float)y, 0.0f);
        }
        x = (double)this.center.x + x * 0.5 * (double)this.size.x;
        y = (double)this.center.y + y * 0.5 * (double)this.size.y;
        float z = this.center.z;
        store.set((float)x, (float)y, z);
    }

    public RadialEmitterShape deepClone() {
        try {
            RadialEmitterShape clone = (RadialEmitterShape)super.clone();
            clone.center = this.center.clone();
            clone.size = this.size.clone();
            return clone;
        }
        catch (CloneNotSupportedException ex) {
            throw new AssertionError();
        }
    }

    public Object jmeClone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new AssertionError();
        }
    }

    public void cloneFields(Cloner cloner, Object original) {
        this.center = (Vector3f)cloner.clone((Object)this.center);
        this.size = (Vector2f)cloner.clone((Object)this.size);
    }

    public void write(JmeExporter ex) throws IOException {
        OutputCapsule oc = ex.getCapsule((Savable)this);
        oc.write((Savable)this.center, "center", null);
        oc.write((Savable)this.size, "size", null);
    }

    public void read(JmeImporter im) throws IOException {
        InputCapsule ic = im.getCapsule((Savable)this);
        this.center = (Vector3f)ic.readSavable("center", null);
        this.size = (Vector2f)ic.readSavable("size", null);
    }
}

