/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mphys;

import com.google.common.base.MoreObjects;
import com.simsilica.mathd.Matrix3d;
import com.simsilica.mathd.Vec3d;
import com.simsilica.mphys.AbstractBody;
import com.simsilica.mphys.AbstractShape;
import com.simsilica.mphys.RigidBody;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Contact<K, S extends AbstractShape> {
    static Logger log = LoggerFactory.getLogger(Contact.class);
    public static final double DEFAULT_FRICTION = 0.7;
    public static final double DEFAULT_RESTITUTION = 0.1;
    public static final double MIN_CONTACT_TEMPERATURE = 0.001;
    public RigidBody<K, S> body1;
    private boolean body1Enabled;
    public AbstractBody<K, S> body2;
    private boolean body2Enabled;
    public Vec3d contactPoint;
    public Vec3d contactNormal;
    public double penetration;
    public double friction = 0.7;
    public double restitution = 0.1;
    private static final double DEFAULT_RESTITUTION_THRESHOLD = 0.25;
    private static double restitutionThreshold = 0.25;
    private static final double DEFAULT_ANGULAR_LIMIT = 0.001;
    private static double angularLimit = 0.001;
    private static final double DEFAULT_LINEAR_LIMIT = 15.0;
    private static double linearLimit = 15.0;
    protected Matrix3d contactToWorld = new Matrix3d();
    protected Vec3d contactVelocity;
    protected double desiredDeltaVelocity;
    protected Vec3d relativeContactPosition1;
    protected Vec3d relativeContactPosition2;
    public double localTemperature;
    private boolean debug;
    public static boolean globalDebug;

    public Contact() {
    }

    public Contact(RigidBody<K, S> body, Vec3d contactPoint, Vec3d contactNormal, double penetration) {
        this(body, null, contactPoint, contactNormal, penetration);
    }

    public Contact(RigidBody<K, S> body1, AbstractBody<K, S> body2, Vec3d contactPoint, Vec3d contactNormal, double penetration) {
        if (body1 == null) {
            throw new IllegalArgumentException("body1 cannot be null");
        }
        if (contactNormal.isNaN()) {
            throw new IllegalArgumentException("Invalid contact normal:" + contactNormal);
        }
        if (body1 == body2) {
            throw new IllegalArgumentException("Self-contacts not allowed:" + body1);
        }
        if (body2 != null && Objects.equals(body1.id, body2.id)) {
            throw new IllegalArgumentException("Different bodies have the same ID, b1:" + body1.id + "  b2:" + body2.id);
        }
        this.body1 = body1;
        this.body1Enabled = true;
        this.body2 = body2;
        this.body2Enabled = body2 instanceof RigidBody;
        this.contactPoint = contactPoint;
        this.contactNormal = contactNormal;
        this.penetration = penetration;
        if (body1 != null) {
            body1.incrementContactCount();
        }
        if (this.body2Enabled) {
            ((RigidBody)body2).incrementContactCount();
        }
    }

    public void setBodies(RigidBody<K, S> body1, AbstractBody<K, S> body2) {
        if (body1 == null) {
            throw new IllegalArgumentException("body1 cannot be null");
        }
        if (body1 == body2) {
            throw new IllegalArgumentException("Self-contacts not allowed:" + body1);
        }
        if (body2 != null && Objects.equals(body1.id, body2.id)) {
            throw new IllegalArgumentException("Different bodies have the same ID, b1:" + body1.id + "  b2:" + body2.id);
        }
        this.body1 = body1;
        this.body1Enabled = true;
        this.body2 = body2;
        this.body2Enabled = body2 instanceof RigidBody;
        if (body1 != null) {
            body1.incrementContactCount();
        }
        if (this.body2Enabled) {
            ((RigidBody)body2).incrementContactCount();
        }
    }

    public boolean hasId(K id) {
        if (id == null) {
            return this.body1 == null || this.body2 == null;
        }
        if (this.body1 != null && id.equals(this.body1.id)) {
            return true;
        }
        return this.body2 != null && id.equals(this.body2.id);
    }

    public final boolean isEnabled() {
        return this.body1Enabled;
    }

    protected boolean isBody2Enabled() {
        return this.body2Enabled;
    }

    public void disable() {
        if (this.body1Enabled) {
            this.body1Enabled = false;
            this.body1.decrementContactCount();
        }
        if (this.body2Enabled) {
            this.body2Enabled = false;
            ((RigidBody)this.body2).decrementContactCount();
        }
    }

    public void disableBody1() {
        if (this.body1Enabled) {
            this.contactNormal.multLocal(-1.0);
            RigidBody<K, S> temp = this.body1;
            this.body1 = (RigidBody)this.body2;
            this.body2 = temp;
            this.body1Enabled = this.body2Enabled;
            this.body2Enabled = false;
            ((RigidBody)this.body2).decrementContactCount();
        }
    }

    public void disableBody2() {
        if (this.body2Enabled) {
            this.body2Enabled = false;
            ((RigidBody)this.body2).decrementContactCount();
        }
    }

    public void setContactInfo(Vec3d contactPoint, Vec3d contactNormal, double penetration) {
        if (contactNormal.isNaN()) {
            throw new IllegalArgumentException("Invalid contact normal:" + contactNormal);
        }
        this.contactPoint = contactPoint;
        this.contactNormal = contactNormal;
        this.penetration = penetration;
    }

    public static void setRestitutionThreshold(double r) {
        restitutionThreshold = r;
    }

    public static double getRestitutionThreshold() {
        return restitutionThreshold;
    }

    public static void setAngularLimit(double d) {
        angularLimit = d;
    }

    public static double getAngularLimit() {
        return angularLimit;
    }

    public static void setLinearLimit(double d) {
        linearLimit = d;
    }

    public static double getLinearLimit() {
        return linearLimit;
    }

    public final RigidBody<K, S> getBody1() {
        return this.body1;
    }

    public final RigidBody<K, S> getBody2() {
        return this.body2Enabled ? (RigidBody)this.body2 : null;
    }

    public double calculateContactTemperature() {
        double result = Math.max(this.body1.getTemperature(), 0.001);
        if (!this.body2Enabled) {
            return result;
        }
        result = Math.max(((RigidBody)this.body2).getTemperature(), result);
        return result;
    }

    public void matchLocalTemperature() {
        this.localTemperature = Math.max(this.body1.getTemperature(), 0.001);
        if (!this.body2Enabled) {
            return;
        }
        this.localTemperature = Math.max(((RigidBody)this.body2).getTemperature(), this.localTemperature);
        this.body1.setTemperature(this.localTemperature);
        ((RigidBody)this.body2).setTemperature(this.localTemperature);
    }

    protected void calculateInternals(double t) {
        if (this.body1 == null) {
            throw new RuntimeException("No body1 specified.");
        }
        this.calculateContactBasis();
        this.relativeContactPosition1 = this.contactPoint.subtract(this.body1.position);
        if (this.body2Enabled) {
            this.relativeContactPosition2 = this.contactPoint.subtract(this.body2.position);
        }
        this.contactVelocity = this.calculateLocalVelocity(this.body1, this.relativeContactPosition1, t);
        if (this.body2Enabled) {
            this.contactVelocity.subtractLocal(this.calculateLocalVelocity((RigidBody)this.body2, this.relativeContactPosition2, t));
        }
        this.calculateDesiredDeltaVelocity(t);
    }

    protected void calculateDesiredDeltaVelocity(double t) {
        double vFromAcc = 0.0;
        if (this.debug) {
            log.debug("lastFrameAccel:" + this.body1.getLastFrameAcceleration());
            log.debug("  cn:" + this.contactNormal);
            log.debug("  pen:" + this.penetration);
        }
        vFromAcc = this.body1.getLastFrameAcceleration().mult(t).dot(this.contactNormal);
        if (this.debug) {
            log.debug("  vFromAcc:" + vFromAcc);
        }
        if (this.body2Enabled) {
            vFromAcc -= ((RigidBody)this.body2).getLastFrameAcceleration().mult(t).dot(this.contactNormal);
        }
        if (this.debug) {
            log.debug("  cVel:" + this.contactVelocity);
            log.debug("  bVel:" + this.body1.getLinearVelocity());
        }
        double r = this.restitution;
        if (Math.abs(this.contactVelocity.x) < restitutionThreshold) {
            r = 0.0;
        }
        this.desiredDeltaVelocity = -this.contactVelocity.x - r * (this.contactVelocity.x - vFromAcc);
        if (this.debug) {
            log.debug("  desiredDeltaV:" + this.desiredDeltaVelocity);
        }
    }

    protected Vec3d calculateLocalVelocity(RigidBody b, Vec3d relContactPos, double t) {
        if (this.debug) {
            log.debug("relContactPos:" + relContactPos);
            log.debug("   rotVel:" + b.getRotationalVelocity());
        }
        Vec3d v = b.getRotationalVelocity().cross(relContactPos);
        if (this.debug) {
            log.debug("   v:" + v);
            log.debug("   linearV:" + b.getLinearVelocity());
        }
        v.addLocal(b.getLinearVelocity());
        if (this.debug) {
            log.debug("   v:" + v);
        }
        Vec3d vContact = this.contactToWorld.transpose().mult(v);
        if (this.debug) {
            log.debug("   vContact:" + vContact);
        }
        Vec3d vAcc = b.getLastFrameAcceleration().mult(t);
        if (this.debug) {
            log.debug("   vAcc:" + vAcc);
        }
        vAcc = this.contactToWorld.transpose().mult(vAcc);
        if (this.debug) {
            log.debug("   vAcc:" + vAcc);
        }
        vAcc.x = 0.0;
        if (this.debug) {
            log.debug("   vAcc:" + vAcc);
        }
        vContact.addLocal(vAcc);
        if (this.debug) {
            log.debug("   vContact:" + vContact);
        }
        return vContact;
    }

    protected void calculateContactBasis() {
        Vec3d contactTangent0 = new Vec3d();
        Vec3d contactTangent1 = new Vec3d();
        if (Math.abs(this.contactNormal.x) > Math.abs(this.contactNormal.y)) {
            double s = 1.0 / Math.sqrt(this.contactNormal.z * this.contactNormal.z + this.contactNormal.x * this.contactNormal.x);
            contactTangent0.x = this.contactNormal.z * s;
            contactTangent0.y = 0.0;
            contactTangent0.z = -this.contactNormal.x * s;
            contactTangent1.x = this.contactNormal.y * contactTangent0.x;
            contactTangent1.y = this.contactNormal.z * contactTangent0.x - this.contactNormal.x * contactTangent0.z;
            contactTangent1.z = -this.contactNormal.y * contactTangent0.x;
        } else {
            double s = 1.0 / Math.sqrt(this.contactNormal.z * this.contactNormal.z + this.contactNormal.y * this.contactNormal.y);
            contactTangent0.x = 0.0;
            contactTangent0.y = -this.contactNormal.z * s;
            contactTangent0.z = this.contactNormal.y * s;
            contactTangent1.x = this.contactNormal.y * contactTangent0.z - this.contactNormal.z * contactTangent0.y;
            contactTangent1.y = -this.contactNormal.x * contactTangent0.z;
            contactTangent1.z = this.contactNormal.x * contactTangent0.y;
        }
        this.contactToWorld.setColumn(0, this.contactNormal);
        this.contactToWorld.setColumn(1, contactTangent0);
        this.contactToWorld.setColumn(2, contactTangent1);
    }

    protected void calculatePositionChange(Vec3d linear1, Vec3d linear2, Vec3d angular1, Vec3d angular2, double penetration) {
        Matrix3d iit;
        double maxMagnitude;
        Vec3d projection;
        Vec3d angularInertiaWorld;
        Matrix3d iit2;
        double angularLimit = 0.001;
        double totalInertia = 0.0;
        double linearInertia1 = 0.0;
        double linearInertia2 = 0.0;
        double angularInertia1 = 0.0;
        double angularInertia2 = 0.0;
        if (this.body1 != null) {
            iit2 = this.body1.getInverseInertiaTensorWorld();
            angularInertiaWorld = this.relativeContactPosition1.cross(this.contactNormal);
            angularInertiaWorld = iit2.mult(angularInertiaWorld);
            angularInertiaWorld = angularInertiaWorld.cross(this.relativeContactPosition1);
            angularInertia1 = angularInertiaWorld.dot(this.contactNormal);
            linearInertia1 = this.body1.getInverseMass();
            totalInertia += linearInertia1 + angularInertia1;
        }
        if (this.body2Enabled) {
            iit2 = ((RigidBody)this.body2).getInverseInertiaTensorWorld();
            angularInertiaWorld = this.relativeContactPosition2.cross(this.contactNormal);
            angularInertiaWorld = iit2.mult(angularInertiaWorld);
            angularInertiaWorld = angularInertiaWorld.cross(this.relativeContactPosition2);
            angularInertia2 = angularInertiaWorld.dot(this.contactNormal);
            linearInertia2 = ((RigidBody)this.body2).getInverseMass();
            totalInertia += linearInertia2 + angularInertia2;
        }
        if (globalDebug && this.body2Enabled) {
            log.debug("linInert1:" + linearInertia1 + " angInert1:" + angularInertia1);
            log.debug("linInert2:" + linearInertia2 + " angInert2:" + angularInertia2);
            log.debug("total inertia:" + totalInertia);
        }
        if (this.body1 != null) {
            double totalMove;
            double sign = 1.0;
            double angularMove1 = sign * penetration * (angularInertia1 / totalInertia);
            double linearMove1 = sign * penetration * (linearInertia1 / totalInertia);
            projection = this.relativeContactPosition1.clone();
            projection.addScaledVectorLocal(this.contactNormal, -this.relativeContactPosition1.dot(this.contactNormal));
            maxMagnitude = angularLimit * projection.length();
            if (angularMove1 < -maxMagnitude) {
                totalMove = angularMove1 + linearMove1;
                angularMove1 = -maxMagnitude;
                linearMove1 = totalMove - angularMove1;
            } else if (angularMove1 > maxMagnitude) {
                totalMove = angularMove1 + linearMove1;
                angularMove1 = maxMagnitude;
                linearMove1 = totalMove - angularMove1;
            } else {
                angularMove1 = 0.0;
            }
            if (angularMove1 == 0.0) {
                angular1.set(0.0, 0.0, 0.0);
            } else {
                Vec3d targetAngularDirection = this.relativeContactPosition1.cross(this.contactNormal);
                iit = this.body1.getInverseInertiaTensorWorld();
                angular1.set(iit.mult(targetAngularDirection).multLocal(angularMove1 / angularInertia1));
            }
            if (linearMove1 > linearLimit) {
                log.warn("Clamping movement:" + linearMove1 + " to:" + linearLimit + " for body1:" + this.body1);
                linearMove1 = linearLimit;
            }
            linear1.set(this.contactNormal.mult(linearMove1));
        }
        if (this.body2Enabled) {
            double sign = -1.0;
            double angularMove2 = sign * penetration * (angularInertia2 / totalInertia);
            double linearMove2 = sign * penetration * (linearInertia2 / totalInertia);
            projection = this.relativeContactPosition2.clone();
            projection.addScaledVectorLocal(this.contactNormal, -this.relativeContactPosition2.dot(this.contactNormal));
            maxMagnitude = angularLimit * projection.length();
            if (angularMove2 < -maxMagnitude) {
                double totalMove = angularMove2 + linearMove2;
                angularMove2 = -maxMagnitude;
                linearMove2 = totalMove - angularMove2;
            } else if (angularMove2 > maxMagnitude) {
                double totalMove = angularMove2 + linearMove2;
                angularMove2 = maxMagnitude;
                linearMove2 = totalMove - angularMove2;
            }
            if (angularMove2 == 0.0) {
                angular2.set(0.0, 0.0, 0.0);
            } else {
                Vec3d targetAngularDirection = this.relativeContactPosition2.cross(this.contactNormal);
                iit = ((RigidBody)this.body2).getInverseInertiaTensorWorld();
                angular2.set(iit.mult(targetAngularDirection).multLocal(angularMove2 / angularInertia2));
            }
            if (linearMove2 > linearLimit) {
                log.warn("Clamping movement:" + linearMove2 + " to:" + linearLimit + " for body2:" + this.body2);
                linearMove2 = linearLimit;
            }
            linear2.set(this.contactNormal.mult(linearMove2));
        }
    }

    protected void calculateVelocityChange(Vec3d vDelta1, Vec3d vDelta2, Vec3d rotDelta1, Vec3d rotDelta2) {
        Vec3d imp;
        Vec3d impContact;
        Matrix3d iit1 = null;
        Matrix3d iit2 = null;
        iit1 = this.body1.getInverseInertiaTensorWorld();
        if (this.body2Enabled) {
            iit2 = ((RigidBody)this.body2).getInverseInertiaTensorWorld();
        }
        if ((impContact = this.friction == 0.0 ? this.calculateFrictionlessImpulse(iit1, iit2) : this.calculateFrictionImpulse(iit1, iit2)).isNaN()) {
            System.out.println("NaN contact impulse.");
        }
        if (this.debug) {
            log.debug("calcVelChange  impContact:" + impContact);
        }
        if ((imp = this.contactToWorld.mult(impContact)).isNaN()) {
            System.out.println("NaN impulse.");
        }
        if (this.debug) {
            log.debug("  imp:" + imp);
        }
        Vec3d impTorque = this.relativeContactPosition1.cross(imp);
        if (this.debug) {
            log.debug("  impTorque:" + impTorque);
        }
        rotDelta1.set(iit1.mult(impTorque));
        if (this.debug) {
            log.debug("  rotDelta1:" + rotDelta1);
        }
        vDelta1.set(0.0, 0.0, 0.0);
        vDelta1.addScaledVectorLocal(imp, this.body1.getInverseMass());
        if (this.debug) {
            log.debug("  invMass:" + this.body1.getInverseMass());
            log.debug("  vDelta1:" + vDelta1);
        }
        if (this.body2Enabled) {
            impTorque = imp.cross(this.relativeContactPosition2);
            rotDelta2.set(iit2.mult(impTorque));
            vDelta2.set(0.0, 0.0, 0.0);
            vDelta2.addScaledVectorLocal(imp, -((RigidBody)this.body2).getInverseMass());
        }
    }

    protected Vec3d calculateFrictionlessImpulse(Matrix3d iit1, Matrix3d iit2) {
        Vec3d impContact = new Vec3d();
        Vec3d vDeltaWorld = this.relativeContactPosition1.cross(this.contactNormal);
        vDeltaWorld = iit1.mult(vDeltaWorld);
        vDeltaWorld = vDeltaWorld.cross(this.relativeContactPosition1);
        double vDelta = vDeltaWorld.dot(this.contactNormal);
        vDelta += this.body1.getInverseMass();
        if (iit2 != null) {
            vDeltaWorld = this.relativeContactPosition2.cross(this.contactNormal);
            vDeltaWorld = iit2.mult(vDeltaWorld);
            vDeltaWorld = vDeltaWorld.cross(this.relativeContactPosition2);
            vDelta += vDeltaWorld.dot(this.contactNormal);
            vDelta += ((RigidBody)this.body2).getInverseMass();
        }
        impContact.x = this.desiredDeltaVelocity / vDelta;
        return impContact;
    }

    protected Vec3d calculateFrictionImpulse(Matrix3d iit1, Matrix3d iit2) {
        double invMass = this.body1.getInverseMass();
        if (this.debug) {
            log.debug("invMass:" + invMass);
        }
        Matrix3d impToTorque = new Matrix3d().setSkewSymmetric(this.relativeContactPosition1);
        Matrix3d vDeltaWorld = impToTorque.clone();
        vDeltaWorld.multLocal(iit1);
        vDeltaWorld.multLocal(impToTorque);
        vDeltaWorld.multLocal(-1.0);
        if (iit2 != null) {
            impToTorque.setSkewSymmetric(this.relativeContactPosition2);
            Matrix3d vDeltaWorld2 = impToTorque.clone();
            vDeltaWorld2.multLocal(iit2);
            vDeltaWorld2.multLocal(impToTorque);
            vDeltaWorld2.multLocal(-1.0);
            vDeltaWorld.addLocal(vDeltaWorld2);
            invMass += ((RigidBody)this.body2).getInverseMass();
        }
        Matrix3d vDelta = this.contactToWorld.transpose();
        vDelta.multLocal(vDeltaWorld);
        vDelta.multLocal(this.contactToWorld);
        vDelta.m00 += invMass;
        vDelta.m11 += invMass;
        vDelta.m22 += invMass;
        Matrix3d impMatrix = vDelta.invert();
        Vec3d velKill = new Vec3d(this.desiredDeltaVelocity, -this.contactVelocity.y, -this.contactVelocity.z);
        if (this.debug) {
            log.debug("  velKill:" + velKill);
        }
        Vec3d impContact = impMatrix.mult(velKill);
        if (this.debug) {
            log.debug("  impContact:" + impContact);
        }
        if (this.friction > 0.0 && impContact.x > 0.0) {
            double planarImp = Math.sqrt(impContact.y * impContact.y + impContact.z * impContact.z);
            if (this.debug) {
                log.debug("  planarImp:" + planarImp + "  total friction:" + impContact.x * this.friction);
            }
            if (planarImp > impContact.x * this.friction) {
                impContact.y /= planarImp;
                impContact.z /= planarImp;
                if (this.debug) {
                    log.debug("  impContact:" + impContact);
                }
                impContact.x = vDelta.m00 + vDelta.m01 * this.friction * impContact.y + vDelta.m02 * this.friction * impContact.z;
                if (this.debug) {
                    log.debug("  impContact:" + impContact);
                }
                impContact.x = this.desiredDeltaVelocity / impContact.x;
                impContact.y *= this.friction * impContact.x;
                impContact.z *= this.friction * impContact.x;
                if (this.debug) {
                    log.debug("  impContact:" + impContact);
                }
            }
            if (impContact.isNaN()) {
                System.out.println("NaN contact impulse desiredDeltaV:" + this.desiredDeltaVelocity + " planarImp:" + planarImp);
                System.out.println("velKill:" + velKill);
            }
        }
        return impContact;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Contact").add("cp", (Object)this.contactPoint).add("cn", (Object)this.contactNormal).add("p", this.penetration).add("f", this.friction).add("r", this.restitution).add("b1", this.body1).add("b2", this.body2).toString();
    }
}

