/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mworld.net.client;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import com.simsilica.mathd.Vec3d;
import com.simsilica.mathd.Vec3i;
import com.simsilica.mblock.CellData;
import com.simsilica.mblock.CellDataNeighborhood;
import com.simsilica.mblock.MaskUtils;
import com.simsilica.mblock.io.BlockTypeData;
import com.simsilica.mblock.io.FluidTypeData;
import com.simsilica.mworld.CellChangeEvent;
import com.simsilica.mworld.DataType;
import com.simsilica.mworld.FluidData;
import com.simsilica.mworld.LeafData;
import com.simsilica.mworld.LeafId;
import com.simsilica.mworld.LightData;
import com.simsilica.mworld.TileId;
import com.simsilica.mworld.base.AbstractWorld;
import com.simsilica.mworld.io.ProtocolSerializers;
import com.simsilica.mworld.net.WorldDataSession;
import com.simsilica.mworld.tile.Resolution;
import com.simsilica.mworld.tile.TerrainImage;
import com.simsilica.mworld.tile.TerrainImageId;
import com.simsilica.mworld.tile.TerrainImageType;
import com.simsilica.mworld.tile.TileChangeEvent;
import com.simsilica.mworld.tile.TileResolutionId;
import com.simsilica.mworld.tile.pc.PointCloudLayer;
import com.simsilica.mworld.tile.tree.TreeLayer;
import com.simsilica.mworld.tile.tree.TreeTypeIndex;
import com.simsilica.mworld.transaction.CellEdit;
import com.simsilica.util.CacheTracker;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteWorldData
extends AbstractWorld {
    static Logger log = LoggerFactory.getLogger(RemoteWorldData.class);
    private WorldDataSession delegate;
    private int yMax;
    private AtomicLong nextRequestId = new AtomicLong(42L);
    private Map<Long, PacketCollector> packetCollectors = new ConcurrentHashMap<Long, PacketCollector>();
    private ProtocolSerializers protocols = new ProtocolSerializers();
    private LoadingCache<LeafId, LeafData> leafCache = CacheBuilder.newBuilder().removalListener((RemovalListener)new RemovalListener<LeafId, LeafData>(){

        public void onRemoval(RemovalNotification<LeafId, LeafData> notification) {
            if (log.isTraceEnabled()) {
                log.trace("leafCacheRemoval(" + notification + ") reason:" + notification.getCause());
            }
        }
    }).weakValues().recordStats().build((CacheLoader)new CacheLoader<LeafId, LeafData>(){

        public LeafData load(LeafId key) {
            return RemoteWorldData.this.loadLeaf(key);
        }
    });
    private LoadingCache<LeafId, LightData> lightCache;
    private LoadingCache<LeafId, FluidData> fluidCache;
    private LoadingCache<TerrainImageId, TerrainImage> terrainCache;
    private LoadingCache<TileResolutionId, TreeLayer> treeCache;
    private LoadingCache<TileResolutionId, PointCloudLayer> pointCloudCache;

    public RemoteWorldData() {
        CacheTracker.track(this.leafCache, (String)"remote:leaf", (boolean)true);
        this.lightCache = CacheBuilder.newBuilder().removalListener((RemovalListener)new RemovalListener<LeafId, LightData>(){

            public void onRemoval(RemovalNotification<LeafId, LightData> notification) {
                if (log.isTraceEnabled()) {
                    log.trace("lightCacheRemoval(" + notification + ") reason:" + notification.getCause());
                }
            }
        }).weakValues().recordStats().build((CacheLoader)new CacheLoader<LeafId, LightData>(){

            public LightData load(LeafId key) {
                return RemoteWorldData.this.loadLight(key);
            }
        });
        CacheTracker.track(this.lightCache, (String)"remote:light", (boolean)true);
        this.fluidCache = CacheBuilder.newBuilder().removalListener((RemovalListener)new RemovalListener<LeafId, FluidData>(){

            public void onRemoval(RemovalNotification<LeafId, FluidData> notification) {
                if (log.isTraceEnabled()) {
                    log.trace("fluidCacheRemoval(" + notification + ") reason:" + notification.getCause());
                }
            }
        }).weakValues().recordStats().build((CacheLoader)new CacheLoader<LeafId, FluidData>(){

            public FluidData load(LeafId key) {
                return RemoteWorldData.this.loadFluid(key);
            }
        });
        CacheTracker.track(this.fluidCache, (String)"remote:fluid", (boolean)true);
        this.terrainCache = CacheBuilder.newBuilder().removalListener((RemovalListener)new RemovalListener<TerrainImageId, TerrainImage>(){

            public void onRemoval(RemovalNotification<TerrainImageId, TerrainImage> notification) {
                if (log.isTraceEnabled()) {
                    log.trace("terrainCacheRemoval(" + notification + ") reason:" + notification.getCause());
                }
            }
        }).weakValues().recordStats().build((CacheLoader)new CacheLoader<TerrainImageId, TerrainImage>(){

            public TerrainImage load(TerrainImageId key) {
                return RemoteWorldData.this.loadTerrainImage(key.getTileId(), key.getType(), key.getResolution());
            }
        });
        CacheTracker.track(this.terrainCache, (String)"remote:terrain", (boolean)true);
        this.treeCache = CacheBuilder.newBuilder().removalListener((RemovalListener)new RemovalListener<TileResolutionId, TreeLayer>(){

            public void onRemoval(RemovalNotification<TileResolutionId, TreeLayer> notification) {
                if (log.isTraceEnabled()) {
                    log.trace("treeCacheRemoval(" + notification + ") reason:" + notification.getCause());
                }
            }
        }).weakValues().recordStats().build((CacheLoader)new CacheLoader<TileResolutionId, TreeLayer>(){

            public TreeLayer load(TileResolutionId key) {
                return RemoteWorldData.this.loadTrees(key.getTileId(), key.getResolution());
            }
        });
        CacheTracker.track(this.treeCache, (String)"remote:tree", (boolean)true);
        this.pointCloudCache = CacheBuilder.newBuilder().removalListener((RemovalListener)new RemovalListener<TileResolutionId, PointCloudLayer>(){

            public void onRemoval(RemovalNotification<TileResolutionId, PointCloudLayer> notification) {
                if (log.isTraceEnabled()) {
                    log.trace("pointCloudCacheRemoval(" + notification + ") reason:" + notification.getCause());
                }
            }
        }).weakValues().recordStats().build((CacheLoader)new CacheLoader<TileResolutionId, PointCloudLayer>(){

            public PointCloudLayer load(TileResolutionId key) {
                return RemoteWorldData.this.loadPointCloudLayer(key.getTileId(), key.getResolution());
            }
        });
        CacheTracker.track(this.pointCloudCache, (String)"remote:pointCloud", (boolean)true);
    }

    public void start(WorldDataSession delegate) {
        if (delegate == null) {
            throw new IllegalArgumentException("World cannot be started with null WorldDataSession");
        }
        this.delegate = delegate;
    }

    public boolean isRunning() {
        return this.delegate != null;
    }

    public void stop() {
        this.delegate = null;
    }

    @Override
    public int getMaxY() {
        if (this.yMax == 0 && this.delegate != null) {
            this.yMax = this.delegate.getMaxY();
        }
        return this.yMax;
    }

    @Override
    public int setWorldCell(Vec3d world, int cellType) {
        throw new UnsupportedOperationException();
    }

    @Override
    public LeafData getLeaf(LeafId leafId) {
        return (LeafData)this.leafCache.getUnchecked((Object)leafId);
    }

    @Override
    public LightData getLight(LeafId leafId) {
        return (LightData)this.lightCache.getUnchecked((Object)leafId);
    }

    @Override
    public FluidData getFluid(LeafId leafId) {
        return (FluidData)this.fluidCache.getUnchecked((Object)leafId);
    }

    public LeafData getLeafIfPresent(LeafId leafId) {
        return (LeafData)this.leafCache.getIfPresent((Object)leafId);
    }

    public LightData getLightIfPresent(LeafId leafId) {
        return (LightData)this.lightCache.getIfPresent((Object)leafId);
    }

    public FluidData getFluidIfPresent(LeafId leafId) {
        return (FluidData)this.fluidCache.getIfPresent((Object)leafId);
    }

    @Override
    public TerrainImage getTerrainImage(TileId id, TerrainImageType type, Resolution res) {
        return (TerrainImage)this.terrainCache.getUnchecked((Object)new TerrainImageId(id, type, res));
    }

    @Override
    public TreeLayer getTrees(TileId id, Resolution res) {
        return (TreeLayer)this.treeCache.getUnchecked((Object)new TileResolutionId(id, res));
    }

    @Override
    public PointCloudLayer getPointCloudLayer(TileId id, Resolution res) {
        return (PointCloudLayer)this.pointCloudCache.getUnchecked((Object)new TileResolutionId(id, res));
    }

    protected CellChangeEvent cellChanged(long leafId, byte[] data, boolean zipped) {
        try {
            CellChangeEvent event = this.protocols.fromBytes(CellChangeEvent.class, data, zipped);
            return event;
        }
        catch (IOException e) {
            throw new RuntimeException("Error deserializing cell change event data for:" + leafId, e);
        }
    }

    protected TileChangeEvent tileChanged(Class dataType, long tileId, long dataVersion, Resolution res) {
        TileChangeEvent event = new TileChangeEvent(dataType, new TileId(tileId), dataVersion, res);
        return event;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<LeafId> setLocalWorldCell(Vec3i world, int value) {
        LeafData neighbor;
        LeafId n;
        log.info("setLocalWorldCell(" + world + ", " + value + ")");
        if (world.y == 0) {
            log.warn("Cannot remove 'bedrock'");
            return null;
        }
        LeafId leafId = LeafId.fromWorld(world);
        LeafData leaf = (LeafData)this.leafCache.getIfPresent((Object)leafId);
        if (leaf == null) {
            return null;
        }
        Vec3i origin = leafId.getWorld(null);
        Vec3i loc = world.subtract(origin);
        int existing = MaskUtils.getType((int)leaf.getCell(loc.x, loc.y, loc.z, value));
        if (existing == value) {
            return null;
        }
        CellDataNeighborhood neighborhood = new CellDataNeighborhood((CellData)leaf, new Vec3i(32, 32, 32), 1);
        HashSet<LeafId> changes = new HashSet<LeafId>();
        changes.add(leafId);
        if (loc.x == 0) {
            n = LeafId.fromWorld(origin.subtract(32, 0, 0));
            neighbor = (LeafData)this.leafCache.getIfPresent((Object)leafId);
            if (neighbor == null) {
                return null;
            }
            neighborhood.setCellData(-1, 0, 0, (CellData)neighbor);
            changes.add(n);
        }
        if (loc.y == 0 && origin.y >= 32) {
            n = LeafId.fromWorld(origin.subtract(0, 32, 0));
            neighbor = (LeafData)this.leafCache.getIfPresent((Object)leafId);
            if (neighbor == null) {
                return null;
            }
            neighborhood.setCellData(0, -1, 0, (CellData)neighbor);
            changes.add(n);
        }
        if (loc.z == 0) {
            n = LeafId.fromWorld(origin.subtract(0, 0, 32));
            neighbor = (LeafData)this.leafCache.getIfPresent((Object)leafId);
            if (neighbor == null) {
                return null;
            }
            neighborhood.setCellData(0, 0, -1, (CellData)neighbor);
            changes.add(n);
        }
        if (loc.x == 31) {
            n = LeafId.fromWorld(origin.add(32, 0, 0));
            neighbor = (LeafData)this.leafCache.getIfPresent((Object)leafId);
            if (neighbor == null) {
                return null;
            }
            neighborhood.setCellData(1, 0, 0, (CellData)neighbor);
            changes.add(n);
        }
        if (loc.y == 31 && origin.y + 32 <= this.yMax) {
            n = LeafId.fromWorld(origin.add(0, 32, 0));
            neighbor = (LeafData)this.leafCache.getIfPresent((Object)leafId);
            if (neighbor == null) {
                return null;
            }
            neighborhood.setCellData(0, 1, 0, (CellData)neighbor);
            changes.add(n);
        }
        if (loc.z == 31) {
            n = LeafId.fromWorld(origin.add(0, 0, 32));
            neighbor = (LeafData)this.leafCache.getIfPresent((Object)leafId);
            if (neighbor == null) {
                return null;
            }
            neighborhood.setCellData(0, 0, 1, (CellData)neighbor);
            changes.add(n);
        }
        RemoteWorldData remoteWorldData = this;
        synchronized (remoteWorldData) {
            neighborhood.setCell(loc.x, loc.y, loc.z, value);
            MaskUtils.recalculateSideMasks((CellData)neighborhood, (int)loc.x, (int)loc.y, (int)loc.z, (int)0);
        }
        return changes;
    }

    protected boolean applyEdits(DataType dataType, CellData cells, CellEdit[] edits) {
        boolean changed = false;
        for (CellEdit edit : edits) {
            if (!edit.apply(dataType, cells)) continue;
            changed = true;
        }
        return changed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean applyChange(CellChangeEvent event) {
        if (log.isTraceEnabled()) {
            log.trace("applyChange(" + event + ")");
            if (event.getBlockChanges() != null) {
                log.trace("Block changes:" + Arrays.asList(event.getBlockChanges()));
            }
            if (event.getLightChanges() != null) {
                log.trace("Light changes:" + Arrays.asList(event.getLightChanges()));
            }
            if (event.getFluidChanges() != null) {
                log.trace("Fluid changes:" + Arrays.asList(event.getFluidChanges()));
            }
        }
        boolean changed = false;
        LeafData blocks = (LeafData)this.leafCache.getIfPresent((Object)event.getLeafId());
        FluidData fluid = (FluidData)this.fluidCache.getIfPresent((Object)event.getLeafId());
        LightData lights = (LightData)this.lightCache.getIfPresent((Object)event.getLeafId());
        Object lock = blocks;
        if (lock == null) {
            lock = fluid;
        }
        if (lock == null) {
            lock = lights;
        }
        if (lock == null) {
            return true;
        }
        Object object = lock;
        synchronized (object) {
            if (event.getBlockChanges() != null) {
                if (blocks != null) {
                    RemoteWorldData remoteWorldData = this;
                    synchronized (remoteWorldData) {
                        if (this.applyEdits(DataType.Block, blocks, event.getBlockChanges())) {
                            if (log.isTraceEnabled()) {
                                log.trace("cells changed");
                            }
                            changed = true;
                        }
                    }
                } else {
                    changed = true;
                }
            }
            if (event.getFluidChanges() != null) {
                if (fluid != null) {
                    if (this.applyEdits(DataType.Fluid, fluid, event.getFluidChanges())) {
                        log.trace("fluid changed");
                        changed = true;
                    }
                } else {
                    changed = true;
                }
            }
            if (event.getLightChanges() != null) {
                if (lights != null) {
                    if (this.applyEdits(DataType.Light, lights, event.getLightChanges())) {
                        log.trace("light changed");
                        changed = true;
                    }
                } else {
                    changed = true;
                }
            }
        }
        return changed;
    }

    protected void resetLeaf(LeafId id, Runnable callback) {
        PacketCollector<Object> collector;
        if (log.isTraceEnabled()) {
            log.trace("resetLeaf(" + id + ")");
        }
        log.info("resetLeaf(" + id + ")");
        LeafData blocks = (LeafData)this.leafCache.getIfPresent((Object)id);
        FluidData fluid = (FluidData)this.fluidCache.getIfPresent((Object)id);
        LightData lights = (LightData)this.lightCache.getIfPresent((Object)id);
        Object lockCandidate = blocks;
        if (lockCandidate == null) {
            lockCandidate = fluid;
        }
        if (lockCandidate == null) {
            lockCandidate = lights;
        }
        if (lockCandidate == null) {
            return;
        }
        Object lock = lockCandidate;
        AtomicInteger count = new AtomicInteger(0);
        if (blocks != null) {
            count.incrementAndGet();
        }
        if (fluid != null) {
            count.incrementAndGet();
        }
        if (lights != null) {
            count.incrementAndGet();
        }
        if (blocks != null) {
            collector = this.newCollector(LeafData.class);
            collector.onDone(c -> {
                Object object = lock;
                synchronized (object) {
                    blocks.setData((LeafData)collector.getObject());
                    if (count.decrementAndGet() <= 0) {
                        callback.run();
                    }
                }
            });
            this.getDelegate().requestLeafData(((PacketCollector)collector).requestId, id.getId());
        }
        if (fluid != null) {
            collector = this.newCollector(FluidData.class);
            collector.onDone(c -> {
                Object object = lock;
                synchronized (object) {
                    fluid.setData((FluidData)collector.getObject());
                    if (count.decrementAndGet() <= 0) {
                        callback.run();
                    }
                }
            });
            this.getDelegate().requestFluidData(((PacketCollector)collector).requestId, id.getId());
        }
        if (lights != null) {
            collector = this.newCollector(LightData.class);
            collector.onDone(c -> {
                Object object = lock;
                synchronized (object) {
                    lights.setData((LightData)collector.getObject());
                    if (count.decrementAndGet() <= 0) {
                        callback.run();
                    }
                }
            });
            this.getDelegate().requestLightData(((PacketCollector)collector).requestId, id.getId());
        }
    }

    protected boolean applyChange(TileChangeEvent event) {
        this.terrainCache.invalidate((Object)new TerrainImageId(event.getTileId(), TerrainImageType.Terrain, event.getResolution()));
        this.terrainCache.invalidate((Object)new TerrainImageId(event.getTileId(), TerrainImageType.Fluid, event.getResolution()));
        TileResolutionId id = new TileResolutionId(event.getTileId(), event.getResolution());
        this.treeCache.invalidate((Object)id);
        this.pointCloudCache.invalidate((Object)id);
        return true;
    }

    protected WorldDataSession getDelegate() {
        if (this.delegate == null) {
            throw new IllegalStateException("Not started");
        }
        return this.delegate;
    }

    protected void partReceived(long requestId, byte part, byte total, byte[] data) {
        PacketCollector collector;
        if (log.isTraceEnabled()) {
            log.trace("partReceived(" + requestId + ", " + part + ", " + total + ", " + data + ")");
            log.trace("Received array length:" + (data == null ? "null" : String.valueOf(data.length)));
        }
        if ((collector = this.packetCollectors.get(requestId)) == null) {
            throw new RuntimeException("No collector found for:" + requestId);
        }
        collector.packetReceived(part, total, data);
    }

    protected <T> PacketCollector<T> newCollector(Class<T> type) {
        long requestId = this.nextRequestId.incrementAndGet();
        PacketCollector<T> collector = new PacketCollector<T>(requestId, type);
        this.packetCollectors.put(requestId, collector);
        return collector;
    }

    public BlockTypeData getBlockTypeData() {
        PacketCollector<BlockTypeData> collector = this.newCollector(BlockTypeData.class);
        this.getDelegate().requestIndexData(((PacketCollector)collector).requestId, WorldDataSession.IndexType.BlockType);
        return collector.getObject();
    }

    public FluidTypeData getFluidTypeData() {
        PacketCollector<FluidTypeData> collector = this.newCollector(FluidTypeData.class);
        this.getDelegate().requestIndexData(((PacketCollector)collector).requestId, WorldDataSession.IndexType.FluidType);
        return collector.getObject();
    }

    public TreeTypeIndex getTreeTypeIndex() {
        PacketCollector<TreeTypeIndex> collector = this.newCollector(TreeTypeIndex.class);
        this.getDelegate().requestIndexData(((PacketCollector)collector).requestId, WorldDataSession.IndexType.TreeType);
        return collector.getObject();
    }

    protected LeafData loadLeaf(LeafId leafId) {
        PacketCollector<LeafData> collector = this.newCollector(LeafData.class);
        this.getDelegate().requestLeafData(((PacketCollector)collector).requestId, leafId.getId());
        return collector.getObject();
    }

    protected LightData loadLight(LeafId leafId) {
        PacketCollector<LightData> collector = this.newCollector(LightData.class);
        this.getDelegate().requestLightData(((PacketCollector)collector).requestId, leafId.getId());
        return collector.getObject();
    }

    protected FluidData loadFluid(LeafId leafId) {
        PacketCollector<FluidData> collector = this.newCollector(FluidData.class);
        this.getDelegate().requestFluidData(((PacketCollector)collector).requestId, leafId.getId());
        return collector.getObject();
    }

    protected TerrainImage loadTerrainImage(TileId id, TerrainImageType type, Resolution res) {
        PacketCollector<TerrainImage> collector = this.newCollector(TerrainImage.class);
        this.getDelegate().requestTerrainImage(((PacketCollector)collector).requestId, id.getId(), type, res);
        return collector.getObject();
    }

    protected TreeLayer loadTrees(TileId id, Resolution res) {
        PacketCollector<TreeLayer> collector = this.newCollector(TreeLayer.class);
        this.getDelegate().requestTrees(((PacketCollector)collector).requestId, id.getId(), res);
        return collector.getObject();
    }

    protected PointCloudLayer loadPointCloudLayer(TileId id, Resolution res) {
        PacketCollector<PointCloudLayer> collector = this.newCollector(PointCloudLayer.class);
        this.getDelegate().requestPointCloudLayer(((PacketCollector)collector).requestId, id.getId(), res);
        return collector.getObject();
    }

    private class PacketCollector<T> {
        private long requestId;
        private Class<T> type;
        private byte[][] buffers;
        private int received;
        private int total;
        private T result;
        private Consumer<PacketCollector<T>> callback;

        public PacketCollector(long requestId, Class<T> type) {
            this.requestId = requestId;
            this.type = type;
        }

        public PacketCollector<T> onDone(Consumer<PacketCollector<T>> callback) {
            this.callback = callback;
            return this;
        }

        private boolean isDone() {
            return this.total > 0 && this.received == this.total;
        }

        public T getObject() {
            if (this.result != null) {
                return this.result;
            }
            byte[][] array = this.getData();
            if (array == null) {
                return null;
            }
            this.result = RemoteWorldData.this.protocols.fromPackets(this.type, Arrays.asList(array), true);
            return this.result;
        }

        protected synchronized byte[][] getData() {
            while (!this.isDone()) {
                try {
                    if (log.isTraceEnabled()) {
                        log.trace("waiting or:" + this.requestId);
                    }
                    this.wait();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException("We were interrupted and there isn't a damn thing we can do about it", e);
                }
            }
            return this.buffers;
        }

        protected void close() {
            RemoteWorldData.this.packetCollectors.remove(this.requestId);
            this.notifyAll();
            if (this.callback != null) {
                this.callback.accept(this);
            }
        }

        public synchronized void packetReceived(int part, int total, byte[] data) {
            if (log.isTraceEnabled()) {
                log.trace("packeteCollector.dataReceived(" + part + ", " + total + ") requestId:" + this.requestId);
            }
            if (data != null) {
                if (this.buffers == null) {
                    this.buffers = new byte[total][];
                    this.total = total;
                }
                this.buffers[part] = data;
            } else {
                if (part != 0 && total != 1) {
                    throw new IllegalArgumentException("Null data for part:" + part + " of:" + total);
                }
                this.total = total;
            }
            this.received = part + 1;
            if (this.isDone()) {
                this.close();
            }
        }
    }
}

