/*
 * Decompiled with CFR 0.152.
 */
package mythruna.es;

import com.google.common.base.MoreObjects;
import com.simsilica.es.EntityComponent;
import com.simsilica.es.EntityData;
import com.simsilica.es.EntityId;
import com.simsilica.es.PersistentComponent;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Holding
implements EntityComponent,
PersistentComponent {
    static Logger log = LoggerFactory.getLogger(Holding.class);
    private EntityId target;
    private int manipulatorType;

    public Holding() {
    }

    public Holding(EntityId target, int manipulatorType) {
        this.target = target;
        this.manipulatorType = manipulatorType;
    }

    public static Holding create(EntityId target, String manipulatorTypeName, EntityData ed) {
        int id = ed.getStrings().getStringId(manipulatorTypeName, false);
        if (id < 0) {
            id = ed.getStrings().getStringId(manipulatorTypeName, true);
        }
        return new Holding(target, id);
    }

    public EntityId getTarget() {
        return this.target;
    }

    public int getManipulatorType() {
        return this.manipulatorType;
    }

    public String getManipulatorTypeName(EntityData ed) {
        if (this.manipulatorType == -1) {
            return null;
        }
        return ed.getStrings().getString(this.manipulatorType);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        Holding other = (Holding)o;
        if (!Objects.equals(this.target, other.target)) {
            return false;
        }
        return other.manipulatorType == this.manipulatorType;
    }

    public int hashCode() {
        return Objects.hash(this.target, this.manipulatorType);
    }

    public String toString() {
        return this.toString(null);
    }

    public String toString(EntityData ed) {
        String s = ed == null ? String.valueOf(this.manipulatorType) : this.getManipulatorTypeName(ed);
        return MoreObjects.toStringHelper((String)this.getClass().getSimpleName()).add("target", (Object)this.target).add("manipulatorType", (Object)s).toString();
    }
}

