/*
 * Decompiled with CFR 0.152.
 */
package mythruna.net.server;

import com.jme3.network.HostedConnection;
import com.jme3.network.service.AbstractHostedConnectionService;
import com.jme3.network.service.HostedServiceManager;
import com.jme3.network.service.ServiceManager;
import com.jme3.network.service.rmi.RmiHostedService;
import com.jme3.network.service.rmi.RmiRegistry;
import com.simsilica.action.ActionEnvironment;
import com.simsilica.action.ObjectTypeRegistry;
import com.simsilica.es.CreatedBy;
import com.simsilica.es.EntityComponent;
import com.simsilica.es.EntityData;
import com.simsilica.es.EntityId;
import com.simsilica.es.Name;
import com.simsilica.event.EventBus;
import com.simsilica.event.EventType;
import com.simsilica.event.PlayerEntityEvent;
import com.simsilica.mathd.Quatd;
import com.simsilica.mathd.Rayd;
import com.simsilica.mathd.Vec3d;
import com.simsilica.mworld.BlockIterator;
import com.simsilica.sim.GameSystemManager;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import mythruna.es.ObjectTypeInfo;
import mythruna.net.AccountEvent;
import mythruna.net.CharacterListener;
import mythruna.net.CharacterSession;
import mythruna.net.server.AccountHostedService;
import mythruna.shape.ShapeName;
import mythruna.sim.Activator;
import mythruna.sim.AppearanceSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CharacterHostedService
extends AbstractHostedConnectionService {
    static Logger log = LoggerFactory.getLogger(CharacterHostedService.class);
    private static final String ATTRIBUTE_SESSION = CharacterHostedService.class.getName();
    private RmiHostedService rmiService;
    private int channel;
    private GameSystemManager systems;
    private EntityData ed;
    private ObjectTypeRegistry<Activator, EntityId> objectTypes;

    public CharacterHostedService(GameSystemManager systems) {
        this(systems, -2);
    }

    public CharacterHostedService(GameSystemManager systems, int channel) {
        this.systems = systems;
        this.channel = channel;
        this.setAutoHost(false);
    }

    protected CharacterSessionImpl getSession(HostedConnection conn) {
        return (CharacterSessionImpl)conn.getAttribute(ATTRIBUTE_SESSION);
    }

    protected void setupObjectTypes() {
        this.objectTypes = (ObjectTypeRegistry)this.systems.get(ObjectTypeRegistry.class);
    }

    protected void onInitialize(HostedServiceManager s) {
        this.rmiService = (RmiHostedService)this.getService(RmiHostedService.class);
        if (this.rmiService == null) {
            throw new RuntimeException(((Object)((Object)this)).getClass().getSimpleName() + " requires an RMI service.");
        }
        this.ed = (EntityData)this.systems.get(EntityData.class, true);
        EventBus.addListener((Object)((Object)this), (EventType[])new EventType[]{AccountEvent.accountLoggedOn, AccountEvent.accountLoggedOff});
        this.setupObjectTypes();
    }

    public void terminate(HostedServiceManager serviceManager) {
        super.terminate((ServiceManager)serviceManager);
        EventBus.removeListener((Object)((Object)this), (EventType[])new EventType[]{AccountEvent.accountLoggedOn, AccountEvent.accountLoggedOff});
    }

    public void startHostingOnConnection(HostedConnection conn) {
        throw new UnsupportedOperationException("Autohosting not supported");
    }

    public void stopHostingOnConnection(HostedConnection conn) {
        log.debug("stopHostingOnConnection(" + conn + ")");
        CharacterSessionImpl session = this.getSession(conn);
        if (session != null) {
            session.close();
            conn.setAttribute(ATTRIBUTE_SESSION, null);
        }
    }

    protected void accountLoggedOn(AccountEvent event) {
        log.info("accountLoggedOn(" + event + ")");
        HostedConnection conn = event.getConnection();
        CharacterSessionImpl session = new CharacterSessionImpl(conn);
        conn.setAttribute(ATTRIBUTE_SESSION, (Object)session);
        RmiRegistry rmi = this.rmiService.getRmiRegistry(conn);
        rmi.share((byte)this.channel, (Object)session, CharacterSession.class);
        session.initialize(rmi);
    }

    protected void accountLoggedOff(AccountEvent event) {
        log.info("accountLoggedOff(" + event + ")");
        this.stopHostingOnConnection(event.getConnection());
    }

    private class CharacterSessionImpl
    implements CharacterSession,
    CharacterListener {
        private HostedConnection conn;
        private CharacterListener callback;
        private EntityId userEntity;

        public CharacterSessionImpl(HostedConnection conn) {
            this.conn = conn;
            this.userEntity = AccountHostedService.getUserEntity(conn);
        }

        public void initialize(RmiRegistry rmi) {
            this.callback = (CharacterListener)rmi.getRemoteObject(CharacterListener.class);
            if (this.callback == null) {
                throw new RuntimeException("Unable to locate client callback for CharacterListener");
            }
            this.callback.sessionAvailable();
        }

        public void close() {
        }

        protected CharacterListener getCallback() {
            return this.callback;
        }

        protected void checkCharacter(EntityId character) {
            CreatedBy creator = (CreatedBy)CharacterHostedService.this.ed.getComponent(character, CreatedBy.class);
            if (creator == null) {
                throw new RuntimeException("Invalid character:" + character);
            }
            log.info("  owner:" + creator);
            if (!Objects.equals(this.userEntity, creator.getCreatorId())) {
                throw new RuntimeException("Invalid character:" + character + " for player:" + this.userEntity);
            }
        }

        @Override
        public EntityId createCharacter(String name, EntityComponent ... components) {
            EntityId character = CharacterHostedService.this.ed.createEntity();
            CharacterHostedService.this.ed.setComponents(character, components);
            CharacterHostedService.this.ed.setComponents(character, new EntityComponent[]{new Name(name), new CreatedBy(this.userEntity)});
            CharacterHostedService.this.ed.setComponents(character, new EntityComponent[]{ObjectTypeInfo.create("PlayerCharacter", CharacterHostedService.this.ed)});
            EventBus.publish((EventType)PlayerEntityEvent.playerEntityCreated, (Object)new PlayerEntityEvent(character, this.conn));
            return character;
        }

        @Override
        public void updateCharacter(EntityId character, EntityComponent ... components) {
            this.checkCharacter(character);
            CharacterHostedService.this.ed.setComponents(character, components);
            CharacterHostedService.this.ed.setComponents(character, new EntityComponent[]{ObjectTypeInfo.create("PlayerCharacter", CharacterHostedService.this.ed)});
        }

        @Override
        public String getCharacterPreviewShapeId(EntityComponent ... components) {
            ShapeName shape = ((AppearanceSystem)((Object)CharacterHostedService.this.systems.get(AppearanceSystem.class, true))).calculateBaseShape(components);
            return shape.toCompositeString();
        }

        @Override
        public void runCharacterAction(EntityId character, EntityId target, int actionId, Object ... parms) {
            String cmd = CharacterHostedService.this.ed.getStrings().getString(actionId);
            this.runCharacterAction(character, target, cmd, parms);
        }

        @Override
        public void runCharacterAction(EntityId character, EntityId target, String actionName, Object ... parms) {
            this.checkCharacter(character);
            ObjectTypeInfo type = (ObjectTypeInfo)CharacterHostedService.this.ed.getComponent(character, ObjectTypeInfo.class);
            if (type == null || !"PlayerCharacter".equals(type.getTypeName(CharacterHostedService.this.ed))) {
                throw new RuntimeException("Not a 'PlayerCharacter', id:" + character + " type:" + type);
            }
            CharacterActivator activator = new CharacterActivator(character);
            ActionEnvironment actionEnv = CharacterHostedService.this.objectTypes.createEnvironment((Object)activator);
            CharacterHostedService.this.systems.enqueue(() -> {
                try {
                    actionEnv.runAction((Object)target, actionName, parms);
                }
                catch (RuntimeException e) {
                    log.error("Error running action:" + actionName + " on target:" + target + " with:" + Arrays.asList(parms), (Throwable)e);
                }
                return null;
            });
        }

        @Override
        public void sessionAvailable() {
            this.getCallback().sessionAvailable();
        }
    }

    private class CharacterActivator
    implements Activator {
        private EntityId entity;
        private Map<String, Object> vars;

        public CharacterActivator(EntityId entity) {
            this.entity = entity;
        }

        @Override
        public EntityId getId() {
            return this.entity;
        }

        @Override
        public Vec3d getEyePos() {
            return null;
        }

        @Override
        public Vec3d getPos() {
            return null;
        }

        @Override
        public Vec3d getLookDir() {
            return null;
        }

        @Override
        public Vec3d getDir() {
            return null;
        }

        @Override
        public Quatd getLookOrientation() {
            return null;
        }

        @Override
        public Quatd getOrientation() {
            return null;
        }

        @Override
        public Iterator<BlockIterator.Intersection> pick() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Iterator<BlockIterator.Intersection> pick(Rayd ray, double limit) {
            throw new UnsupportedOperationException();
        }

        @Override
        public <T extends EntityComponent> T getAt(Class<T> type) {
            return (T)((EntityComponent)type.cast(CharacterHostedService.this.ed.getComponent(this.entity, type)));
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[" + this.entity.getId() + "]";
        }

        @Override
        public Object getProperty(String name) {
            if (log.isDebugEnabled()) {
                log.debug("getProperty(" + name + ")");
            }
            return this.vars.get(name);
        }

        @Override
        public void setProperty(String name, Object newValue) {
            if (log.isDebugEnabled()) {
                log.debug("setProperty(" + name + ", " + newValue + ")");
            }
            this.vars.put(name, newValue);
        }
    }
}

