/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.progress;

import com.simsilica.lemur.core.VersionedObject;
import com.simsilica.lemur.core.VersionedReference;
import com.simsilica.progress.ProgressTrackers;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProgressTracker
implements VersionedObject<ProgressTracker> {
    static Logger log = LoggerFactory.getLogger(ProgressTracker.class);
    private String name;
    private volatile double max;
    private volatile double progress;
    private AtomicLong version = new AtomicLong(0L);
    private boolean closed;

    public ProgressTracker(String name) {
        if (log.isTraceEnabled()) {
            log.trace("creating:" + name + " this:" + this);
        }
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public long getVersion() {
        return this.version.get();
    }

    public ProgressTracker getObject() {
        return this;
    }

    public VersionedReference<ProgressTracker> createReference() {
        return new VersionedReference((VersionedObject)this);
    }

    public void setMax(double max) {
        this.max = max;
    }

    public double getMax() {
        return this.max;
    }

    public void setProgress(double progress) {
        if (this.progress == progress) {
            return;
        }
        this.progress = progress;
        if (log.isTraceEnabled()) {
            log.trace(this.name + ":setProgress(" + progress + ")  " + String.format("%.02f", this.getPercent() * 100.0));
        }
        this.version.incrementAndGet();
    }

    public double getProgress() {
        return this.progress;
    }

    public double increment() {
        return this.add(1.0);
    }

    public double add(double delta) {
        this.setProgress(this.progress + delta);
        return this.progress;
    }

    public double getPercent() {
        if (this.max == 0.0) {
            return 0.0;
        }
        return this.progress / this.max;
    }

    public void close(boolean done) {
        if (log.isTraceEnabled()) {
            log.trace("close(" + done + "):" + this.name + " this:" + this);
        }
        if (this.closed) {
            return;
        }
        if (done && this.progress < this.max) {
            this.setProgress(this.max);
        }
        ProgressTrackers.close(this);
        this.closed = true;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public String toString() {
        return "ProgressTracker[name:" + this.name + ", progress:" + this.progress + ", max:" + this.max + "]";
    }
}

