/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.state;

import com.jme3.app.Application;
import com.jme3.app.SimpleApplication;
import com.jme3.app.state.BaseAppState;
import com.jme3.math.Vector3f;
import com.jme3.post.SceneProcessor;
import com.jme3.renderer.Camera;
import com.jme3.renderer.ViewPort;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.util.SafeArrayList;
import com.simsilica.lemur.Axis;
import com.simsilica.lemur.Container;
import com.simsilica.lemur.FillMode;
import com.simsilica.lemur.HAlignment;
import com.simsilica.lemur.Label;
import com.simsilica.lemur.component.BorderLayout;
import com.simsilica.lemur.component.SpringGridLayout;
import com.simsilica.lemur.core.GuiLayout;
import com.simsilica.lemur.core.VersionedHolder;
import com.simsilica.lemur.core.VersionedReference;
import com.simsilica.lemur.input.FunctionId;
import com.simsilica.lemur.style.ElementId;
import com.simsilica.post.DefaultSceneProcessor;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DebugHudState
extends BaseAppState {
    static Logger log = LoggerFactory.getLogger(DebugHudState.class);
    public static final FunctionId HUD_TOGGLE = new FunctionId("Show Debug HUD");
    public static final ElementId SCREEN_ID = new ElementId("debug.screen.container");
    public static final ElementId CONTAINER_ID = new ElementId("debug.container");
    public static final ElementId NAME_ID = new ElementId("debug.name.label");
    public static final ElementId VALUE_ID = new ElementId("debug.value.label");
    private Node hudRoot;
    private Container screen;
    private float zOffset = 0.0f;
    private ReshapeListener reshapeListener = new ReshapeListener();
    private boolean sizeInvalid;
    private Container top;
    private Container bottom;
    private Container left;
    private Container right;
    private final Map<String, DebugView> viewIndex = new HashMap<String, DebugView>();
    private final SafeArrayList<DebugView> views = new SafeArrayList(DebugView.class);

    public void createDebugValue(String name, Location location, VersionedReference<String> value) {
        DebugView view = new DebugView(name, location, value);
        this.views.add((Object)view);
        this.viewIndex.put(name, view);
        switch (location) {
            case Top: {
                view.nameLabel.setTextHAlignment(HAlignment.Right);
                this.top.addChild((Node)view.nameLabel, new Object[0]);
                this.top.addChild((Node)view.label, new Object[0]);
                break;
            }
            case Bottom: {
                view.nameLabel.setTextHAlignment(HAlignment.Right);
                this.bottom.addChild((Node)view.nameLabel, new Object[0]);
                this.bottom.addChild((Node)view.label, new Object[0]);
                break;
            }
            case Right: {
                this.right.addChild((Node)view.nameLabel, new Object[0]);
                this.right.addChild((Node)view.label, new Object[]{1});
                break;
            }
            default: {
                this.left.addChild((Node)view.nameLabel, new Object[0]);
                this.left.addChild((Node)view.label, new Object[]{1});
            }
        }
        this.resetScreenSize();
    }

    public VersionedHolder<String> createDebugValue(String name, Location location) {
        VersionedHolder result = new VersionedHolder((Object)"");
        this.createDebugValue(name, location, (VersionedReference<String>)result.createReference());
        return result;
    }

    public void removeDebugValue(String name) {
        DebugView view = this.viewIndex.remove(name);
        if (view == null) {
            return;
        }
        this.views.remove((Object)view);
        switch (view.location) {
            case Top: {
                this.top.removeChild((Node)view.nameLabel);
                this.top.removeChild((Node)view.label);
                break;
            }
            case Bottom: {
                this.bottom.removeChild((Node)view.nameLabel);
                this.bottom.removeChild((Node)view.label);
                break;
            }
            case Right: {
                this.right.removeChild((Node)view.nameLabel);
                this.right.removeChild((Node)view.label);
                break;
            }
            default: {
                this.left.removeChild((Node)view.nameLabel);
                this.left.removeChild((Node)view.label);
            }
        }
    }

    public void setHudRoot(Node root) {
        this.hudRoot = root;
    }

    public Node getHudRoot() {
        if (this.hudRoot != null) {
            return this.hudRoot;
        }
        return ((SimpleApplication)this.getApplication()).getGuiNode();
    }

    protected ViewPort getHudViewPort() {
        return this.getApplication().getGuiViewPort();
    }

    public void setZOffset(float z) {
        this.zOffset = z;
    }

    public float getZOffset() {
        return this.zOffset;
    }

    protected void initialize(Application app) {
        this.screen = new Container((GuiLayout)new BorderLayout(), SCREEN_ID);
        this.screen.setBackground(null);
        ElementId containerId = CONTAINER_ID;
        this.top = (Container)this.screen.addChild((Node)new Container((GuiLayout)new SpringGridLayout(Axis.X, Axis.Y), containerId), new Object[]{BorderLayout.Position.North});
        this.bottom = (Container)this.screen.addChild((Node)new Container((GuiLayout)new SpringGridLayout(Axis.X, Axis.Y), containerId), new Object[]{BorderLayout.Position.South});
        this.left = (Container)this.screen.addChild((Node)new Container((GuiLayout)new SpringGridLayout(Axis.Y, Axis.X, FillMode.None, FillMode.Last), containerId), new Object[]{BorderLayout.Position.West});
        this.right = (Container)this.screen.addChild((Node)new Container((GuiLayout)new SpringGridLayout(Axis.Y, Axis.X, FillMode.None, FillMode.Last), containerId), new Object[]{BorderLayout.Position.East});
    }

    protected void cleanup(Application app) {
    }

    protected void resetScreenSize() {
        Camera cam = this.getApplication().getCamera();
        this.screen.setPreferredSize(null);
        Vector3f pref = this.screen.getPreferredSize();
        if (log.isTraceEnabled()) {
            log.trace("resetScreenSize()  cam:" + cam.getWidth() + ", " + cam.getHeight());
        }
        this.screen.setPreferredSize(new Vector3f((float)cam.getWidth(), (float)cam.getHeight(), pref.z));
        this.screen.setLocalTranslation(0.0f, (float)cam.getHeight(), this.zOffset);
        this.sizeInvalid = false;
    }

    protected void onEnable() {
        Camera cam = this.getApplication().getCamera();
        this.screen.setLocalTranslation(0.0f, (float)cam.getHeight(), this.zOffset);
        this.getHudRoot().attachChild((Spatial)this.screen);
        this.getHudViewPort().addProcessor((SceneProcessor)this.reshapeListener);
        this.resetScreenSize();
    }

    public void update(float tpf) {
        if (this.sizeInvalid) {
            this.resetScreenSize();
        }
        for (DebugView view : (DebugView[])this.views.getArray()) {
            view.update();
        }
    }

    protected void onDisable() {
        this.screen.removeFromParent();
        this.getHudViewPort().removeProcessor((SceneProcessor)this.reshapeListener);
    }

    private class ReshapeListener
    extends DefaultSceneProcessor {
        private ReshapeListener() {
        }

        @Override
        public void reshape(ViewPort vp, int w, int h) {
            if (log.isTraceEnabled()) {
                log.trace("reshape(" + vp + ", " + w + ", " + h + ")");
            }
            DebugHudState.this.sizeInvalid = true;
        }
    }

    private class DebugView {
        String name;
        VersionedReference<String> ref;
        Label nameLabel;
        Label label;
        Location location;

        public DebugView(String name, Location location, VersionedReference<String> ref) {
            this.name = name;
            this.location = location;
            this.ref = ref;
            this.nameLabel = new Label(name + ": ", new ElementId("debug.name.label"));
            this.label = new Label((String)ref.get(), new ElementId("debug.value.label"));
        }

        public void update() {
            if (this.ref.update()) {
                this.label.setText((String)this.ref.get());
            }
        }
    }

    public static enum Location {
        Top,
        Left,
        Bottom,
        Right;

    }
}

